/*
 * This file is part of Nuts Framework.
 * Copyright (C) 2009 Nuts Develop Team.
 *
 * Nuts Framework is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License any later version.
 *
 * Nuts Framework is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Nuts Framework. If not, see <http://www.gnu.org/licenses/>.
 */
package nuts.exts.xwork2.validator.validators;

import java.util.HashMap;
import java.util.Map;

import net.sf.json.JSONObject;
import nuts.exts.struts2.test.StrutsTestCase;
import nuts.exts.struts2.test.TestAction;
import nuts.exts.struts2.test.TestBean;
import nuts.exts.xwork2.validator.validators.FileNameFieldValidator;

import com.opensymphony.xwork2.ActionProxy;

/**
 * @see FileNameFieldValidator
 */
public class FileNameFieldValidatorTest extends StrutsTestCase {
	protected void doSuccessTest(String action, String value) throws Exception {
		TestBean tbd = new TestBean();

		Map<String, String> rps = new HashMap<String, String>();

		tbd.setStringField(value);
		tbd.setDataToMap(rps, "bean.");

		ActionProxy proxy = createActionProxy("/test", action, null, rps);

		assertTrue(proxy.getAction() instanceof TestAction);

		// Run the Struts Interceptor stack and the Action
		String result = proxy.execute();

		// Check the results
		assertEquals(TestAction.SUCCESS, result);

		String rc = getResponseContentAsString();

		JSONObject rjo = JSONObject.fromObject(rc);
		assertTrue(rjo.getBoolean("success"));
	}

	protected void doErrorTest(String action, String value) throws Exception {
		TestBean tbd = new TestBean();

		Map<String, String> rps = new HashMap<String, String>();

		tbd.setStringField(value);
		tbd.setDataToMap(rps, "bean.");

		ActionProxy proxy = createActionProxy("/test", action, null, rps);

		assertTrue(proxy.getAction() instanceof TestAction);

		// Run the Struts Interceptor stack and the Action
		String result = proxy.execute();

		// Check the results
		assertEquals(TestAction.INPUT, result);

		String rc = getResponseContentAsString();

		JSONObject rjo = JSONObject.fromObject(rc);
		assertFalse(rjo.getBoolean("success"));

		JSONObject fes = rjo.getJSONObject("fieldErrors");
		assertNotNull(fes);
		assertTrue(fes.containsKey("bean.stringField"));
	}

	/**
	 * field value: "2008abc121"<br>
	 * expect success
	 * @throws Exception if an error occurs
	 */
	public void test001() throws Exception {
		doSuccessTest("filenamevalidate", "2008abc121");
	}

	/**
	 * field value: "2010/1/1"<br>
	 * expect error
	 * @throws Exception if an error occurs
	 */
	public void test002() throws Exception {
		doErrorTest("filenamevalidate", "2010/1/1");
	}

}
