/*
 * This file is part of Nuts Framework.
 * Copyright (C) 2009 Nuts Develop Team.
 *
 * Nuts Framework is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License any later version.
 * 
 * Nuts Framework is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Nuts Framework. If not, see <http://www.gnu.org/licenses/>.
 */
package nuts.exts.struts2.test;

import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * Bean for test
 */
public class TestBean {
	private Boolean booleanField;
	private Byte byteField;
	private Character charField;
	private int intField;
	private Long longField;
	private Float floatField;
	private Double doubleField;
	private String stringField;
	private Date dateField;
	private File fileField;
	private Object objectField;

	private Map map;
	private List list;
	private String[] strArray;
	private int[] intArray;
	private byte[] byteArray;
	
	private TestBean self;

	/**
	 * dateFormat: yyyy/MM/dd HH:mm:ss
	 */
	public SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");

	/**
	 * set dummy test data
	 */
	public void setTestData() {
		booleanField = true;
		byteField = 127;
		charField = 'c';
		intField = 100;
		longField = 123456789L;
		floatField = 1.5f;
		doubleField = 10.1;
		stringField = "testStr";
		dateField = Calendar.getInstance().getTime();
		self = this;
	}

	/**
	 * set data to map
	 * @param map map 
	 * @param prefix the prefix of data
	 */
	public void setDataToMap(Map<String, String> map, String prefix) {
		if (booleanField != null) {
			map.put(prefix + "booleanField", String.valueOf(booleanField));
		}
		if (charField != null) {
			map.put(prefix + "charField", String.valueOf(charField));
		}
		if (byteField != null) {
			map.put(prefix + "byteField", String.valueOf(byteField));
		}
		map.put(prefix + "intField", String.valueOf(intField));
		if (longField != null) {
			map.put(prefix + "longField", String.valueOf(longField));
		}
		if (floatField != null) {
			map.put(prefix + "floatField", String.valueOf(floatField));
		}
		if (doubleField != null) {
			map.put(prefix + "doubleField", String.valueOf(doubleField));
		}
		if (stringField != null) {
			map.put(prefix + "stringField", String.valueOf(stringField));
		}
		if (dateField != null) {
			map.put(prefix + "dateField", dateFormat.format(dateField));
		}
	}

	/**
	 * @return the self
	 */
	public TestBean getSelf() {
		return self;
	}

	/**
	 * @param self the self to set
	 */
	public void setSelf(TestBean self) {
		this.self = self;
	}

	/**
	 * @return the booleanField
	 */
	public Boolean getBooleanField() {
		return booleanField;
	}

	/**
	 * @param booleanField the booleanField to set
	 */
	public void setBooleanField(Boolean booleanField) {
		this.booleanField = booleanField;
	}

	/**
	 * @return the byteField
	 */
	public Byte getByteField() {
		return byteField;
	}

	/**
	 * @param byteField the byteField to set
	 */
	public void setByteField(Byte byteField) {
		this.byteField = byteField;
	}

	/**
	 * @return the charField
	 */
	public Character getCharField() {
		return charField;
	}

	/**
	 * @param charField the charField to set
	 */
	public void setCharField(Character charField) {
		this.charField = charField;
	}

	/**
	 * @return the intField
	 */
	public int getIntField() {
		return intField;
	}

	/**
	 * @param intField the intField to set
	 */
	public void setIntField(int intField) {
		this.intField = intField;
	}

	/**
	 * @return the longField
	 */
	public Long getLongField() {
		return longField;
	}

	/**
	 * @param longField the longField to set
	 */
	public void setLongField(Long longField) {
		this.longField = longField;
	}

	/**
	 * @return the floatField
	 */
	public Float getFloatField() {
		return floatField;
	}

	/**
	 * @param floatField the floatField to set
	 */
	public void setFloatField(Float floatField) {
		this.floatField = floatField;
	}

	/**
	 * @return the doubleField
	 */
	public Double getDoubleField() {
		return doubleField;
	}

	/**
	 * @param doubleField the doubleField to set
	 */
	public void setDoubleField(Double doubleField) {
		this.doubleField = doubleField;
	}

	/**
	 * @return the stringField
	 */
	public String getStringField() {
		return stringField;
	}

	/**
	 * @param stringField the stringField to set
	 */
	public void setStringField(String stringField) {
		this.stringField = stringField;
	}

	/**
	 * @return the dateField
	 */
	public Date getDateField() {
		return dateField;
	}

	/**
	 * @param dateField the dateField to set
	 */
	public void setDateField(Date dateField) {
		this.dateField = dateField;
	}

	/**
	 * @return the fileField
	 */
	public File getFileField() {
		return fileField;
	}

	/**
	 * @param fileField the fileField to set
	 */
	public void setFileField(File fileField) {
		this.fileField = fileField;
	}

	/**
	 * @return the objectField
	 */
	public Object getObjectField() {
		return objectField;
	}

	/**
	 * @param objectField the objectField to set
	 */
	public void setObjectField(Object objectField) {
		this.objectField = objectField;
	}

	/**
	 * @return the map
	 */
	public Map getMap() {
		return map;
	}

	/**
	 * @param map the map to set
	 */
	public void setMap(Map map) {
		this.map = map;
	}

	/**
	 * @return the list
	 */
	public List getList() {
		return list;
	}

	/**
	 * @param list the list to set
	 */
	public void setList(List list) {
		this.list = list;
	}

	/**
	 * @return the strArray
	 */
	public String[] getStrArray() {
		return strArray;
	}

	/**
	 * @param strArray the strArray to set
	 */
	public void setStrArray(String[] strArray) {
		this.strArray = strArray;
	}

	/**
	 * @return the intArray
	 */
	public int[] getIntArray() {
		return intArray;
	}

	/**
	 * @param intArray the intArray to set
	 */
	public void setIntArray(int[] intArray) {
		this.intArray = intArray;
	}

	/**
	 * @return the byteArray
	 */
	public byte[] getByteArray() {
		return byteArray;
	}

	/**
	 * @param byteArray the byteArray to set
	 */
	public void setByteArray(byte[] byteArray) {
		this.byteArray = byteArray;
	}

}
