<#--
/*
 * This file is part of Nuts.
 * Copyright (C) 2009 Nuts Develop Team.
 *
 * Nuts is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License any later version.
 *
 * Nuts is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Nuts. If not, see <http://www.gnu.org/licenses/>.
 */
-->
<#assign head = ""/>
<#assign status_code = (Request["javax.servlet.error.status_code"]!'')?string />
<#assign title = action.getText("servlet-error-title-" + status_code, "")/>
<#if !(title?has_content)><#assign title = action.getText("servlet-error-title", status_code, [status_code])/></#if>
<#assign title = "<<" + title + ">>"/>
<#assign message = action.getText("servlet-error-message-" + status_code, "")/>
<#if !(message?has_content)><#assign message = action.getText("servlet-error-message", "", [status_code])/></#if>
<#if !(message?has_content)><#assign message = Request["javax.servlet-error-message"]!''/></#if>
<#assign body = '<div class="n-section">'
		+ '<div class="n-section-head">'
			+ '<em class="n-section-icon n-icon n-icon-cancel"></em>'
			+ '<h3 class="n-section-title n-error">'
				+ title 
				+ ' -- ' 
				+ action.getText('servlet-error-status-code', 'HTTP STATUS ' + status_code, [ status_code ])
			+ '</h3>'
		+ '</div>'
		+ '<div class="n-section-body">'
			+ '<div class="n-action-prompt n-error-content">'
				+ '<ul class="n-action-errors">'
					+ '<li class="n-action-error">' 
						+ '<img class="n-icon n-icon-error n-action-error" src="${base}/static/nuts/images/s.gif">' + message + '<br/>'
						+ action.getText('servlet-error-request-url', [ utils.getRequestURL(100) ]) 
					+ '</li>'
				+ '</ul>'
			+ '</div>'
/>
<#if Request['javax.servlet.error.exception']??>
	<@n.log category='${utils.action.class.name}' level='error' exception='#request["javax.servlet.error.exception"]'>SERVLET ERROR:</@n.log>
	<#if utils.debugEnabled>
		<#assign body = body 
				+ '<div class="n-exception ui-corner-all">'
					+ '<h4>' + action.getText('servlet-error-exception') + '</h4>'
					+ '<div>' + utils.escapePhtml(utils.servletExceptionStackTrace) + '</div>'
				+ '</div>'
		/>
	</#if>
</#if>
<#assign body = body 
		+ '</div>'
	+ '</div>'
/>
<#if "true" == Parameters.__popup!>
	<#include "/decorators/popup.ftl"/>
<#elseif "true" == Parameters.__inner!>
	<#include "/decorators/inner.ftl"/>
<#else>
	<#include "/decorators/main.ftl"/>
</#if>
