<#--
/*
 * This file is part of Nuts Framework.
 * Copyright (C) 2009 Nuts Develop Team.
 *
 * Nuts Framework is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License any later version.
 *
 * Nuts Framework is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Nuts Framework. If not, see <http://www.gnu.org/licenses/>.
 */
-->
<html>
<head>
	<title><@n.text name="title-page"/></title>
	<style type="text/css">
		.sqlexec-tb {
			width: 100%;
		}
		.sqlexec-ol {
		}
		.sqlexec-st {
		}
		.sqlexec-rd {
			margin: 5px 0;
			overflow: auto;
		}
		.sqlexec-rt {
			width: 100%;
		}
	</style>
</head>
<body>

<div class="n-section" id="a_sqlexec">
	<div class="n-section-head">
		<em class="n-section-icon n-icon n-icon-database"></em>
		<h3 class="n-section-title"><@n.text name="title-page"/></h3>
	</div>
	<div class="n-section-body">
		<#include "/nuts/exts/struts2/views/action-prompt.ftl"/>

		<@n.form id="sqlexec" method="post" theme="simple">
		<table class="sqlexec-tb">
			<tr><td>SQL: (Ctrl+Enter to execute)</td>
				<td align="right"><@n.checkbox name="ignoreError" clabel="Ignore Error" fieldValue="true"/></td>
			</tr>
			<tr><td colspan="2"><@n.textarea name="sql" rows="15" cssStyle="width:100%"/></td></tr>
			<tr><td colspan="2" align="center"><@n.submit id="sqlexec_submit" cssClass="submit" icon="n-icon-database_go">execute</@n.submit></td></tr>
		</table>
		</@n.form>
		
		<div class="hr"></div>
		
		<#if results?has_content><ol class="sqlexec-ol">
			<#list results as r><li><span class="sqlexec-st"><@n.property value=r.sql format="phtml"/></span>
				<#if r.updateCount &gt; 0>${r.updateCount} rows updated.<br/></#if>
				<#if r.resultSet?has_content>
				<div class="n-table-wrapper sqlexec-rd">
				<table class="n-table sqlexec-rt">
					<#list r.resultSet as row>
						<#if row_index == 0>
							<thead><tr><#list row as c><th>${(c!)?html}</th></#list></tr></thead>
						<#else>
							<#if row_index == 1><tbody></#if>
							<tr><#list row as c><td>${(c!)?html}</td></#list></tr>
							<#if !row_has_next></tbody></#if>
						</#if>
					</#list>
				</table>
				</div>
				</#if>
				<#if r.error?has_content><pre class="n-error">${r.error?html}</pre></#if>
				<br/>
			</li></#list>
		</ol></#if>
	</div>
	<script type="text/javascript">
		$(function() {
			$('#sqlexec_sql').focus().keyup(function(evt) {
				if (evt.ctrlKey && evt.which == 13) {
					$('#sqlexec_submit').click();
				}
			});
			$('.sqlexec-rd').autosize();
		});
	</script>
</div>

</body>
</html>
