Ext.ns('Nexts.plugins'); 

Nexts.plugins.TabInlineToolbar = function(config) {
	Ext.apply(this, config);
};

Ext.apply(Nexts.plugins.TabInlineToolbar.prototype, {
	width: 100,
	
	init: function(panel) {
		this.panel = panel;
		this.panel.afterRender = this.panel.afterRender.createSequence(this.render, this);
	},
	
	getScrollArea: function() {
		var newScrollArea = this.panel.stripWrap.dom.clientWidth - this.width;
		return parseInt(newScrollArea, 10) || 0;
	},
		
	render: function() {
		this.id = this.id || this.panel.id + '-itbar';
		
		this.wrap = Ext.DomHelper.insertFirst(this.panel.el.dom, 
			'<div id="' + this.id + '" class="x-tab-toolbar-wrap" style="float:right;height:26px;overflow:hidden;border-left:0px;border-top:1px solid #8DB2E3;margin-left:0px;"></div>',
			true);
		
		this.tbarPanel = new Ext.Panel({
			renderTo: this.id,
			border: false,
			tbar: this.tbar
		});
		
		this.tbar = this.tbarPanel.getTopToolbar();

		this.wrap.setWidth(this.width);
		
		if (Ext.isIE) {
			// adjust for scrollbars being present if scrolling
			var extraLength = 0;
			if (this.panel.scrolling) { 
				extraLength = 35; 
			}
			
			// adjust width for IE
			this.panel.header.setWidth(this.getScrollArea() + extraLength);
			var ieh = Ext.DomHelper.insertFirst(this.panel.el.dom, 
				'<div id="' + this.id + '-iehack" class="x-toolbar" style="position:absolute;z-index:-2;height:21px;width:100px;border:1px solid #8DB2E3;border-bottom:1px solid #99BBE8;;"> </div>',
				true);
			ieh.setWidth(this.getScrollArea() + (this.width / 2));
		}
		else {
			this.panel.header.setWidth('auto');	
		}
	},

	getToolbarPanel: function() {
		return this.tbarPanel;
	},
	
	getToolbar: function() {
		return this.tbar;
	}
	
});
