Ext.ns('Nexts.plugins');

// Very simple plugin for adding a close context menu to tabs
Nexts.plugins.TabCloseMenu = function(cfg) {

	Ext.apply(this, cfg);
};

Ext.apply(Nexts.plugins.TabCloseMenu.prototype, {
	closeTabText		: 'Close Tab',
	closeOthersText		: 'Close Other Tabs',

	init: function(tp) {
		this.tabs = tp;
		this.tabs.on('contextmenu', this.onContextMenu, this);
	},
	

	closeTab: function(item) {

		this.tabs.remove(item);

	},

	
	onCloseTab: function() {
		this.closeTab(this.ctxItem);
	},

	onCloseOthers: function() {
		this.tabs.items.each(function(item) {
			if (item.closable && item != this.ctxItem){
				this.closeTab(item);
			}
		}, this);
	},

	onContextMenu: function(ts, item, e) {
		if (!this.menu) { // create context menu on first right click
			this.menu = new Ext.menu.Menu([{
				id: this.tabs.id + '-close',
				text: this.closeTabText,
				handler: this.onCloseTab,
				scope: this
			},{
				id: this.tabs.id + '-close-others',
				text: this.closeOthersText,
				handler: this.onCloseOthers,
				scope: this
			}]);
		}
		
		this.ctxItem = item;
		this.menu.items.get(this.tabs.id + '-close').setDisabled(!item.closable);

		var disableOthers = true;
		
		this.tabs.items.each(function() {
			if (this != item && this.closable){
				disableOthers = false;
				return false;
			}
		});
		
		this.menu.items.get(this.tabs.id + '-close-others').setDisabled(disableOthers);
		
		this.menu.showAt(e.getPoint());
	}
});

