Ext.ns('Nexts.grid'); 

Nexts.grid.GridFilters = Ext.extend(Ext.ux.grid.GridFilters, {		
	/**
	 * @cfg {String} paramPrefix
	 * The url parameter prefix for the filters.
	 */
	paramPrefix: 'filters.',

	/** override **/
	getFilterData: function() {
		var filters = {};
		
		this.filters.each(function(f) {
			if (f.active) {
				filters[f.field ? f.field : f.dataIndex] = f.serialize();
			}
		});
		
		return filters;
	},
	
	/** override **/
	buildQuery: function(filters) {
		var p = {};
		for (var n in filters) {
			var f = filters[n];
			var prefix = this.paramPrefix + n + '.';
			
			for (var k in f) {
				p[prefix + k] = f[k];
			}
		}
		
		return p;
	},
	
	/** override **/
	cleanParams: function(p) {
		for (var key in p) {
			if (key.startsWith(this.paramPrefix)) {
				delete p[key];
			}
		}
	},
	
	/**
	 * Function for locating filter classes, overwrite this with your favorite
	 * loader to provide dynamic filter loading.
	 * 
	 * @param {String} type The type of filter to load.
	 * 
	 * @return {Class}
	 */
	getFilterClass: function(type) {
		return Nexts.grid.filter[ type.capitalize() + 'Filter' ];
	}
});
