Ext.ns('Nexts.form');

/**
 * @class Nexts.form.PanelField
 * @extends Ext.form.TriggerField
 * Provides a date input field with a {@link Ext.DatePicker} dropdown and automatic date validation.
 * @constructor
 * Create a new DateField
 * @param {Object} config
 */
Nexts.form.PanelField = Ext.extend(Ext.form.TriggerField,  {
	xtype: 'r.panelfield',
	
	/**
	 * @cfg {String} dropdownPanel
	 */
	dropdownPanel : null,
	
	/**
	 * @cfg {String} triggerClass
	 * An additional CSS class used to style the trigger button.  The trigger will always get the
	 * class 'x-form-trigger' and triggerClass will be <b>appended</b> if specified (defaults to 'x-form-arrow-trigger'
	 * which displays a calendar icon).
	 */
	triggerClass : 'x-form-arrow-trigger',
	/**
	 * @cfg {String/Object} autoCreate
	 * A DomHelper element spec, or true for a default element spec (defaults to
	 * {tag: "input", type: "text", size: "10", autocomplete: "off"})
	 */

	// private
	defaultAutoCreate : {tag: "input", type: "text"},

	initComponent : function(){
		Nexts.form.PanelField.superclass.initComponent.call(this);
		if(typeof this.minValue == "string"){
			this.minValue = this.parseDate(this.minValue);
		}
		if(typeof this.maxValue == "string"){
			this.maxValue = this.parseDate(this.maxValue);
		}
		this.ddMatch = null;
		if(this.disabledDates){
			var dd = this.disabledDates;
			var re = "(?:";
			for(var i = 0; i < dd.length; i++){
				re += dd[i];
				if(i != dd.length-1) re += "|";
			}
			this.ddMatch = new RegExp(re + ")");
		}
	},

	// private
	// Provides logic to override the default TriggerField.validateBlur which just returns true
	validateBlur : function(){
		return !this.menu || !this.menu.isVisible();
	},

	// private
	onDestroy : function(){
		if(this.menu) {
			this.menu.destroy();
		}
		if(this.wrap){
			this.wrap.remove();
		}
		Nexts.form.PanelField.superclass.onDestroy.call(this);
	},

	// private
	menuListeners : {
		select: function(v){
			this.setValue(v);
		},
		show : function(){ // retain focus styling
			this.onFocus();
		},
		hide : function(){
			this.focus.defer(10, this);
			var ml = this.menuListeners;
			this.menu.un("select", ml.select,  this);
			this.menu.un("show", ml.show,  this);
			this.menu.un("hide", ml.hide,  this);
		}
	},

	// private
	// Implements the default empty TriggerField.onTriggerClick function to display the DatePicker
	onTriggerClick : function(){
		if (this.disabled || this.dropdownPanel == null) {
			return;
		}
		
		if (this.menu == null) {
			this.menu = new Ext.menu.Adapter(this.dropdownPanel);
		}

		this.menu.on(Ext.apply({}, this.menuListeners, {
			scope:this
		}));
		
		if (this.dropdown.setFieldValue) {
			this.dropdown.setFieldValue(this.getValue());
		}
		this.menu.show(this.el, "tl-bl?");
	}
});

Ext.reg('r.panelfield', Nexts.form.PanelField);

