Ext.ns('Nexts'); 

Nexts.ThemeCombo = function() {
	// call parent
	Nexts.ThemeCombo.superclass.constructor.apply(this, arguments);
};

Ext.extend(Nexts.ThemeCombo, Ext.form.ComboBox, {
	xtype: 'r.themecombo',
	
	selectText : 'Select Theme ...',

	// configurables
	lazyRender: true,
	
	lazyInit: true,
	
	// {{{
	initComponent: function() {
		Ext.apply(this, {
			store: new Ext.data.SimpleStore({
				fields: Nexts.Theme.fields,
				data: Nexts.Theme.data
			}),
			valueField: 'css',
			displayField: 'name',
			triggerAction:'all',
			mode: 'local',
			forceSelection:true,
			editable:false,
			fieldLabel: this.selectText
		}); // end of apply

		//this.store.sort('themeName');

		// call parent
		Nexts.ThemeCombo.superclass.initComponent.apply(this, arguments);

		this.setValue(Ext.state.Manager.get(Nexts.Theme.stateId) || 'xtheme-default.css');

	}, // end of function initComponent

	setValue:function(val) {
		Nexts.ThemeCombo.superclass.setValue.apply(this, arguments);

		// set theme
		Ext.util.CSS.swapStyleSheet(Nexts.Theme.cssId, Nexts.Theme.cssPath + val);

		Ext.state.Manager.set(Nexts.Theme.stateId, val);
	} // eo function setValue

}); // end of extend

// register xtype
Ext.reg('r.themecombo', Nexts.ThemeCombo);

// end of file
