Ext.ns('Nexts');

Nexts.AjaxResponsePopup = function(config) {
	var detailPanel = this.createDetailPanel(config);
	
	Ext.apply(config, {
		cls: 'ne-ajaxres-popup-menu',
		items: [ 
			detailPanel
		]
	});
	
	Nexts.AjaxResponsePopup.superclass.constructor.apply(this, arguments);
}

Ext.extend(Nexts.AjaxResponsePopup, Ext.menu.Menu, {
	getObjectTableHtml: function(o) {
		var html = '<table class="ne-ajaxres-popup-table">';
		for (var i in o) {
			var v = o[i];
			switch (typeof(v)) {
			case 'object':
				html += '<tr><th>' + i + ':</th><td>' + (Ext.isArray(v) ? '[' : '{') + '</td></tr>';
				html += '<tr><td colspan="2">' + this.getObjectTableHtml(v) + '</td></tr>';
				html += '<tr><td colspan="2">' + (Ext.isArray(v) ? ']' : '}') + '</td></tr>';
				break;
			default:
				html += '<tr><th>' + i + ':</th><td>' 
					+ String.htmlEncode(v + '').replace(/\n/g, '<br/>').replace(/\t/g, '&nbsp;&nbsp;') 
					+ '</td></tr>';
				break;
			}
		}
		html += '</table>';
		return html;
	},
	
	getJsonResultHtml: function(o) {
		var html = '<div class="ne-ajaxres-popup-json">';
		for (var i in o) {
			html += '<b>' + i + ':</b>';

			var v = o[i];
			switch (typeof(v)) {
			case 'undefined':
				break;
			case 'object':
				html += ' ' + (Ext.isArray(v) ? '[' : '{') + '<br/>';
				html += this.getJsonResultHtml(v);
				html += '' + (Ext.isArray(v) ? ']' : '}') + '';
				break;
			default:
				html += ' ' + String.htmlEncode(v + '').replace(/\n/g, '<br/>').replace(/\t/g, '&nbsp;&nbsp;');
				break;
			}
			html += '<br/>';
		}
		html += '</div>';
		return html;
	},
	
	createDetailPanel: function(config) {
		var action = config.action;
		var response = config.response || (action ? action.response : null);
		var result = config.result || (action ? action.result : null);
		
		var items = [];
		
		if (action) {
			items.push({
				title: 'Request',
				autoScroll: true,
				html: this.getObjectTableHtml({
					'URL': action.getUrl(),
					'Method': action.getMethod(),
					'Parameters': action.getParams(),
					'Form values': action.form.getValues()
				})
			});
		}
			
		if (response) {
			items.push({
				title: 'Response Headers',
				autoScroll: true,
				html: this.getObjectTableHtml(Ext.apply({
					'Status': response.status + ' - ' + response.statusText
				}, response.getResponseHeader))
			});
			
			items.push({
				title: 'Response Text',
				layout: 'fit',
				items: [
					new Ext.form.TextArea({
						readOnly: true,
						value: response.responseText
					})
				]
			});
		}
		
		if (!result && response) {
			try {
				result = Ext.decode(response.responseText);
			}
			catch (ex) {
			}
		}

		if (result && typeof(result) == 'object') {
			items.push({
				title: 'Response JSON Result',
				autoScroll: true,
				html: this.getJsonResultHtml(result)
			});
		}

		var panel = new Ext.Panel({
			cls: 'ne-ajaxres-popup-panel',
			width: 400,
			height: 200,
			layout: 'fit',
			title: 'Ajax Request & Response',
			tools: [{
				id: 'close',
				handler: this.hide.createDelegate(this, [ true ])
			}],
			items: [
				new Ext.TabPanel({
					enableTabScroll: true,
					defaults: {
						bodyStyle: 'padding: 5px;'
					},
					activeTab: 0,
					items: items
				})
			]
		});

		return panel;
	}
});

