Nexts.frame.StartMenu = function(config) {
	config = Ext.applyIf(config || {}, { 
		header: true,
		iconCls: 'ne-icon-user'
	});
	
	this.menu = new Nexts.tree.StaticTreePanel({
		region: 'center',
		id: 'ne-frame-start-menu',
		stateful: true,
		border: false,
		rootVisible: false,
		autoScroll: true,
		listeners: {
			click: this.onMenuClick,
			scope: this
		}
	});
	
	this.tool = new Nexts.tree.StaticTreePanel({
		region: 'south',
		id: 'ne-frame-start-tool',
		stateful: true,
		border: false,
		rootVisible: false,
		split: true,
		useSplitTips: true,
		height: 100,
		autoScroll: true,
		listeners: {
			click: this.onMenuClick,
			scope: this
		}
	});
	
	Nexts.frame.StartMenu.superclass.constructor.call(this, Ext.apply(config, {
		layout: 'border',
		items: [
			this.menu,
			this.tool
		]
	}));
};

Ext.extend(Nexts.frame.StartMenu, Ext.Panel, {
	onMenuClick: function(n) {
		if (n.attributes.handler) {
			n.attributes.handler.call(n.attributes.scope || n);
		}
	},
	
	createModuleNode: function(m) {
		var n = {
			id: 'tn.' + m.id,
			leaf: m.items ? (m.items.length < 1) : true,
			text: m.launcher.text,
			tooltip: m.launcher.tooltip,
			iconCls: m.launcher.iconCls,
			handler: m.launcher.handler,
			scope: m.launcher.scope
		};

		if (!n.leaf) {
			n.children = [];
			for (var i = 0; i < m.items.length; i++) {
				var mc = m.manager.getModule(m.items[i]);
				if (mc) {
					n.children.push(this.createModuleNode(mc));
				}
			}
		}

		return n;
	},
	
	addModule: function(m, tool) {
		var n = this.createModuleNode(m);
		
		var t = tool ? this.tool : this.menu;
		
		t.appendChild(n);
		t.restoreTreeState();
	}
});

