Ext.ns('Nexts.desktop');

Nexts.desktop.Desktop = function(config) {
	this.desktopEl = Ext.getBody().createChild({
		tag: 'div',
		id: 'ne-desktop',
		cls: 'ne-desktop'
	});
	
	this.taskbarEl = Ext.getBody().createChild({
		tag: 'div',
		id: 'ne-taskbar',
		html: '<div id="ne-taskbar-start"></div>'
				+ '<div id="ne-taskbar-panel-wrap">'
				+ '<div id="ne-quickstart"></div>'
				+ '<div id="ne-taskbuttons"></div>'
			+ '</div>'
			+ '<div class="x-clear"></div>'
	});
	
	this.taskbar = new Nexts.desktop.TaskBar({
		startConfig: config ? config.startConfig : null
	});
	
	this.shortcuts = new Nexts.desktop.Shortcuts({
		renderTo: this.desktopEl,
		taskbarEl: this.taskbarEl
	});
	
	this.config = null;
	this.initialConfig = null;

//	this.windows = new Ext.WindowGroup();
	this.windows = Ext.WindowMgr;
	
	this.activeWindow = null;
		
	Ext.EventManager.onWindowResize(this.doLayout, this);

	this.doLayout();
	
	this.cmenu = new Ext.menu.Menu();
	
	this.desktopEl.on('contextmenu', function(e) {
		if (e.target.id === this.desktopEl.id) {
			e.stopEvent();
			if (!this.cmenu.el) {
				this.cmenu.render();
			}
			var xy = e.getXY();
			xy[1] -= this.cmenu.el.getHeight();
			this.cmenu.showAt(xy);
		}
	}, this);

	Nexts.desktop.Desktop.superclass.constructor.call(this);	
};

Ext.extend(Nexts.desktop.Desktop, Ext.util.Observable, {
	waitText				: 'Please wait',
	wallpaperLoadingText	: 'Loading wallpaper...',
	finishedText			: 'Finished',
	wallpaperLoadedText		: 'Wallpaper loaded.',

	initMenuModule: function() {
		var ms = Nexts.module.ModuleManager.getModules();
		for (var i in ms) {
			var m = ms[i];
			if (m.mtype == 'menu') {
				m.initMenu();
			}
		}
	},
	
	minimizeWin: function(win) {
		win.minimized = true;
		win.hide();
	},

	markActive: function(win) {
		if (this.activeWindow && this.activeWindow != win) {
			this.markInactive(this.activeWindow);
		}
		this.taskbar.setActiveButton(win.taskButton);
		this.activeWindow = win;
		Ext.fly(win.taskButton.el).addClass('active-win');
		win.minimized = false;
	},

	markInactive: function(win) {
		if (win == this.activeWindow) {
			this.activeWindow = null;
			Ext.fly(win.taskButton.el).removeClass('active-win');
		}
	},

	removeWin: function(win) {
		this.taskbar.taskButtons.remove(win.taskButton);
		this.doLayout();
	},

	doLayout: function() {
		this.desktopEl.setHeight(Ext.lib.Dom.getViewHeight() - this.taskbarEl.getHeight());
	},

	createWindow: function(cfg, cls) {
		cfg = cfg || {};

		if (!cfg.id && cfg.module) {
			cfg.id = cfg.module.id + '.win';
		}

		cfg.plugins = cfg.plugins || [];
		var im = false;
		for (var i = 0; i < cfg.plugins.length; i++) {
			var p = cfg.plugins[i];
			if (p instanceof Nexts.plugins.IconMenu) {
				im = true;
				break;
			}
		}
		if (!im) {
			cfg.plugins.push(new Nexts.plugins.IconMenu());
		}

		var win = new (cls || Ext.Window) (
			Ext.applyIf(cfg, {
				manager: this.windows,
				minimizable: true,
				maximizable: true,
				modal: false,
				onEsc: Ext.emptyFn
			})
		);
		win.render(this.desktopEl);

		win.taskButton = this.taskbar.taskButtons.add(win);

		win.animateTarget = win.taskButton.el;
		
		win.on({
			'activate': this.markActive,
			'beforeshow': this.markActive,
			'deactivate': this.markInactive,
			'minimize': this.minimizeWin,
			'close': this.removeWin,
			'scope': this
		});
		
		this.doLayout();

		return win;
	},

	activateWindow: function(w, ani) {
		if (ani === false) {
			var ae = w.animateTarget;
			w.show(null);
			w.setAnimateTarget(ae);
		}
		else {
			w.show();
		}
	},
	
	closeWindow: function(w) {
		w.close();
	},
	
	getManager: function() {
		return this.windows;
	},

	getWindow: function(id) {
		return this.windows.get(id);
	},
	
	getViewHeight: function() {
		return (Ext.lib.Dom.getViewHeight()-this.taskbarEl.getHeight());
	},
	
	getViewWidth: function() {
		return Ext.lib.Dom.getViewWidth();
	},
	
	getWinWidth: function() {
		var width = Ext.lib.Dom.getViewWidth();
		return width < 200 ? 200 : width;
	},
		
	getWinHeight: function() {
		var height = (Ext.lib.Dom.getViewHeight()-this.taskbarEl.getHeight());
		return height < 100 ? 100 : height;
	},
		
	getWinX: function(width) {
		return (Ext.lib.Dom.getViewWidth() - width) / 2;
	},
		
	getWinY: function(height) {
		return (Ext.lib.Dom.getViewHeight()-this.taskbarEl.getHeight() - height) / 2;
	},
	
	setTitle: function(title, iconCls) {
		this.taskbar.startMenu.setTitle(title, iconCls);
	},
	
	setBackgroundColor: function(color) {
		if (color) {
			Ext.getBody().setStyle('background-color', '#' + color);
			this.config.styles.backgroundcolor = color;
		}
	},
	
	setFontColor: function(color) {
		if (color) {
			Ext.util.CSS.updateRule('.ne-shortcut-btn-text', 'color', '#' + color);
			this.config.styles.fontcolor = color;
		}
	},
	
	setTheme: function(o) {
		if (o && o.css) {
			Ext.util.CSS.swapStyleSheet(Nexts.Theme.cssId, Nexts.Theme.cssPath + o.css);
			this.config.styles.theme = o;
		}
	},
	
	setTransparency: function(b) {
		if (String(b) != "") {
			if (b) {
				this.taskbarEl.addClass("ne-desktop-transparent");
			}else{
				this.taskbarEl.removeClass("ne-desktop-transparent");
			}
			this.config.styles.transparency = b
		}
	},
	
	setWallpaper: function(w) {
		if (w) {
			if (w.image) {
				this.setWallpaperImage(w.image);
			}
			if (w.position) {
				this.setWallpaperPosition(w.position);
			}
		}
	},
	
	setWallpaperImage: function(img) {
		if (img) {
			var notifyWin = this.showNotification({
				iconCls: 'ne-icon-wait',
				title: this.waitText,
				html: this.wallpaperLoadingText
			});
			
			var wp = new Image();
			wp.src = img;
			
			var task = new Ext.util.DelayedTask(verify, this);
			task.delay(200);
			
			this.config.styles.wallpaper.image = img;
		}
		
		function verify() {
			if (wp.complete) {
				task.cancel();
				
				notifyWin.setIconClass('ne-icon-information');
				notifyWin.setTitle(this.finishedText);
				notifyWin.setMessage(this.wallpaperLoadedText);
				this.hideNotification(notifyWin);
				
				document.body.background = wp.src;
				document.body.style.backgroundImage = 'url(' + img + ')';
			}
			else {
				task.delay(200);
			}
		}
	},
	
	setWallpaperPosition: function(pos) {
		if (pos) {
			if (pos == "center") {
				Ext.getBody().replaceClass('ne-desktop-wallpaper-tile', 'ne-desktop-wallpaper-center');
			}
			else if (pos == "tile") {
				Ext.getBody().replaceClass('ne-desktop-wallpaper-center', 'ne-desktop-wallpaper-tile');
			}			
			this.config.styles.wallpaper.position = pos;
		}
	},
	
	showNotification: function(config) {
		var win = new Nexts.Notification(Ext.apply({
			animateTarget: this.taskbarEl,
			autoDestroy: true,
			hideDelay: 3000,
			title: '',
			html: ''
		}, config));
		
		win.show();

		return win;
	},
	
	hideNotification: function(win, delay) {
		if (win) {
			(function() { win.animHide(); }).defer(delay || 3000);
		}
	},
	
	addAutoRun: function(id) {
		var c = this.config.launchers.autorun;

		if (!c.contains(id)) {
			c.push(id);
		}
	},
	
	removeAutoRun: function(id) {
		var c = this.config.launchers.autorun;
			
		c.remove(id);
	},
	
	// Private
	addContextMenuItem: function(id) {
		var m = Nexts.module.ModuleManager.getModule(id);
		if (m && !m.contextMenuItem) {
			this.cmenu.add(m.launcher);
		}
	},

	addStartMenu: function(m, tool) {		
		var sm = this.taskbar.startMenu;
		
		if (tool === true) {
			sm.addTool(m.launcher);
		} 
		else {
			sm.add(m.launcher);
		}
	},

	addShortcut: function(id, updateConfig) {
		var m = Nexts.module.ModuleManager.getModule(id);
		
		if (m && !m.shortcut) {
			m.shortcut = this.shortcuts.addShortcut(Ext.apply({
				id: id
			}, m.launcher));
			
			if (updateConfig) {
				this.config.launchers.shortcut.push(id);
			}
		}
		
	},

	removeShortcut: function(id, updateConfig) {
		var m = Nexts.module.ModuleManager.getModule(id);
		
		if (m && m.shortcut) {
			this.shortcuts.removeShortcut(m.shortcut);
			delete m.shortcut;
			
			if (updateConfig) {
				this.config.launchers.shortcut.remove(id);
			}
		}
	},

	addQuickStartButton: function(id, updateConfig) {
		var m = Nexts.module.ModuleManager.getModule(id);
		
		if (m && !m.quickstart) {
			m.quickstart = this.taskbar.quickStart.add(m.launcher);
			
			if (updateConfig) {
				this.config.launchers.quickstart.push(id);
			}
		}
	},
	
	removeQuickStartButton: function(id, updateConfig) {
		var m = Nexts.module.ModuleManager.getModule(id);
		
		if (m && m.quickstart) {
			this.taskbar.quickStart.remove(m.quickstart);
			delete m.quickstart;
			
			if (updateConfig) {
				this.config.launchers.quickstart.remove(id);
			}
		}
	}
});
