Ext.ns('Nexts');

Nexts.Shell = function() {
	var desktop = null;
		
	return {
		createDesktop: function(c, cls) {
			c = c || {};
			
			cls = cls || Nexts.desktop.Desktop;
			desktop = new cls();
			
			this.initDesktopConfig(c);
			
			return desktop;
		},
		
		initDesktopConfig: function(c) {
			var o = c.desktopConfig;
			var l = o.launchers;
			
			l.contextmenu = l.contextmenu || [];
			l.startmenu	 = l.startmenu || [];
			l.startmenutool = l.startmenutool || [];
			l.quickstart = l.quickstart || [];
			l.shortcut = l.shortcut || [];
			o.styles = o.styles || [];
			o.styles.wallpaper = o.styles.wallpaper || {};
			l.autorun = l.autorun || [];
			
			desktop.config = o;
			desktop.initialConfig = o;

			desktop.initMenuModule();
			this.initContextMenu(l.contextmenu);
			this.initStartTitle(c.startConfig);
			this.initStartMenu(l.startmenu, false);
			this.initStartMenu(l.startmenutool, true);
			this.initQuickStart(l.quickstart);
			this.initShortcuts(l.shortcut);
			this.initStyles(o.styles);
			this.initAutoRun.defer(100, this, [ l.autorun ]);
		},
		
		initAutoRun: function(mIds) {
			if (mIds) {
				for (var i = 0, len = mIds.length; i < len; i++) {
					var m = Nexts.module.ModuleManager.getModule(mIds[i]);
					if (m && m.autorun !== false) {
						m.launcher.handler.call(m);
					}
				}
			}
		},
	
		initContextMenu: function(mIds) {
			if (mIds) {
				for (var i = 0, len = mIds.length; i < len; i++) {
					desktop.addContextMenuItem(mIds[i]);
				}
			}
		},
		
		initShortcuts: function(mIds) {
			if (mIds) {
				for (var i = 0, len = mIds.length; i < len; i++) {
					desktop.addShortcut(mIds[i], false);
				}
			}
		},
		
		initStartTitle: function(c) {
			desktop.setTitle(c.title, c.iconCls);
		},
		
		initStartMenu: function(mIds, tool) {
			if (mIds) {
				for (var i = 0; i < mIds.length; i++) {
					var m = Nexts.module.ModuleManager.getModule(mIds[i]);
					if (m) {
						desktop.addStartMenu(m, tool);
					}
				}
			}
		},
	
		initQuickStart: function(mIds) {
			if (mIds) {
				for (var i = 0, len = mIds.length; i < len; i++) {
					desktop.addQuickStartButton(mIds[i], false);
				}
			}
		},
		
		initStyles: function(s) {
			desktop.setBackgroundColor(s.backgroundcolor);
			desktop.setFontColor(s.fontcolor);
			desktop.setTheme(s.theme);
			desktop.setTransparency(s.transparency);
			desktop.setWallpaper(s.wallpaper);
		}
	}
}();
