Ext.ns('Nexts.module');

Nexts.module.Module = function(config) {
	Ext.apply(this, config);

	if (!this.app) {
		this.app = Nexts.Applet.getInstance();
	}
	
	if (!this.manager) {
		this.manager = Nexts.module.ModuleManager;
	}
	
	this.initModule();

	Nexts.module.Module.superclass.constructor.call(this);

	this.manager.register(this);

}

Ext.extend(Nexts.module.Module, Ext.util.Observable, {
	mtype: 'base',

	singleton: true,

	iconCls: 'ne-module-icon',

	shortcutIconCls: 'ne-module-shortcut',

	TEXT: null,
	
	getText: function(key, defval) {
		return Nexts.Resources.getText(this.id, key, defval);
	},

	initModule: function() {
		this.title = this.title || this.getText("title");
		this.tooltip = this.tooltip || this.getText("tooltip");
		this.launcher = {
			text: this.title,
			tooltip: this.tooltip || this.title,
			iconCls: this.iconCls,
			shortcutIconCls: this.shortcutIconCls,
			handler: this.launchModule,
			scope: this
		};
	},

	cloneModule: function() {
		var c = {};
		for (var p in this) {
			c[p] = this[p];
		}
		return c;
	},

	isLaunched: Ext.emptyFn,
	
	launchModule: Ext.emptyFn,
	
	activateModule: Ext.emptyFn,
	
	closeModule: Ext.emptyFn
	
});

