Ext.ns('Nexts.module');

Nexts.module.LoginModule = Ext.extend(Nexts.module.Module, {

	mtype: 'system',

	id: 'Nexts.module.LoginModule',
	
	stateId: 'ml',
	
	cookieId: 'ticket',
	
	iconCls: 'ne-login-icon',
	
	shortcutIconCls: 'ne-login-shortcut',
	
	logoCls: 'ne-login-logo',
	
	logoHtml: '<div class="ne-login-title">Nexts web desktop framework</div><div class="ne-login-poweredby"><a href="http://nuts.sourceforge.jp" target="_blank">nuts.sourceforge.jp</a></div>',
	
	formCls: 'ne-login-form',
	
	url: '.',
	
	title: 'Login',
	
	usernameText: 'User name',
	
	passwordText: 'Password',
	
	saveUsernameText: 'Remember me on this computer',
	
	savePasswordText: 'Remember my password',

	autoLoginText: 'Login automatically',
	
	loginButtonText: 'Login',
	
	waitMsgText: 'Login...',
	
	initModule: function() {
		this.addEvents('login');
		
		Nexts.module.LoginModule.superclass.initModule.call(this);
		
		this.app.loginModule = this;
		this.on({
			login: this.app.onLogin,
			scope: this.app
		});
	},

	launchModule: function() {
		if (!this.win) {
			this.win = this.createWindow();
		}
		this.win.show();
	},
	
	createWindow: function() {
		var s = this.loadLoginInfo();
		
		this.formPanel = new Nexts.form.FormPanel({
			cls: this.formCls,
			url: this.url,
			stateful: false,
			labelAlign: 'right',
			labelWidth: 110,
			border: false,
			frame: false,
			autoWidth: true,
			autoHeight: true,
			defaults: { 
				allowBlank: false,
				msgTarget: 'under'
			},
			items: [{
				xtype: 'textfield',
				name: 'username',
				maxLength: 32,
				width: 200,
				value: s.username,
				fieldLabel: this.usernameText
			}, {
				xtype: 'textfield',
				inputType: 'password',
				name: 'password',
				minLength: 6,
				width: 200,
				maxLength: 16,
				value: s.password,
				fieldLabel: this.passwordText
			}, {
				xtype: 'checkbox',
				name: 'saveUsername',
				checked: s.saveUsername,
				fieldLabel: '',
				labelSeparator: '',
				boxLabel: this.saveUsernameText
			}, {
				xtype: 'checkbox',
				name: 'savePassword',
				checked: s.savePassword,
				fieldLabel: '',
				labelSeparator: '',
				boxLabel: this.savePasswordText
			}, {
				xtype: 'checkbox',
				name: 'autoLogin',
				checked: s.autoLogin,
				fieldLabel: '',
				labelSeparator: '',
				boxLabel: this.autoLoginText
			}],
			buttonAlign: 'center',
			buttons: [{
				text: this.loginButtonText,
				handler: this.doLogin,
				scope: this
			}],
			listeners: {
				actioncomplete: this.onActionComplete,
				scope: this
			}
		});
	
		this.win = new Ext.Window({
			id: this.id + '.win',
			title: this.title,
			iconCls: this.iconCls,
			cls: 'ne-login-win',
			stateful: false,
			closable: false,
			resizable: false,
			minHeight: 250,
			minWidth: 400,
			width: 400,
			plain: false,
			modal: true,
			plugins: new Nexts.plugins.CenterWindow(),
			items: [
				new Ext.Panel({
					stateful: false,
					border: false,
					cls: this.logoCls,
					html: this.logoHtml
				}),
				this.formPanel
			],
			listeners: {
				activate : {
					fn : this.onActivate,
					scope: this,
					delay: 200
				}
			}
		});

		if (s.username && s.password && s.autoLogin && !s.logout) {
			this.doLogin.defer(500, this);
		}
		
		return this.win;
	},
	
	onActivate: function() {
		if (Ext.isEmpty(this.formPanel.getForm().items.itemAt(0).getValue())) {
			this.formPanel.setFocusItem(0);
		}
		else {
			this.formPanel.setFocusItem(1);
		}
	},
	
	doLogin: function() {
		this.saveLoginInfo();
		this.formPanel.getForm().subload({waitMsg: this.waitMsgText});
	},

	loadLoginInfo: function() {
		var li;
		try {
			var cs = String.decodeBase64(this.app.cookie.get(this.cookieId));
			li = Ext.util.JSON.decode(cs);
			li = {
				username: li.u,
				password: li.p,
				saveUsername: li.su,
				savePassword: li.sp,
				autoLogin: li.al
			};
		}
		catch (ex) {
			console.warn(ex);
			li = {};
		}
	
		return li;
	},
	
	saveLoginInfo: function() {
		var fvs = this.formPanel.getForm().getValues();
		var cvs = {};
		
		if (fvs.saveUsername || fvs.saveUsername == 'on') {
			cvs.u = fvs.username.strip();
			cvs.su = true;
			if (fvs.savePassword || fvs.savePassword == 'on') {
				cvs.p = fvs.password.strip();
				cvs.sp = true;
				if (fvs.autoLogin || fvs.autoLogin == 'on') {
					cvs.al = true;
				}
			}
			var cs = Ext.util.JSON.encode(cvs);
			this.app.cookie.set(this.cookieId, String.encodeBase64(cs));
		}
	},
	
	onActionComplete: function(form, action) {
		var result = action.result;
		if (result) {
			this.win.hide();
			this.fireEvent("login", result);
		}
		else {
			this.formPanel.formMessages.onActionLoadFailure(form, action);
		}
	}
});


