Ext.ns('Nexts.module');

Nexts.module.FormModule = Ext.extend(Nexts.module.WindowModule, {
	mtype: 'form',
	
	defaultWindowConfig: {
		modal: false,
		constrainHeader: true,
		closable: true,
		resizable: false,
		maximizable: false,
		autoWidth: false,
		autoHeight: true,
		plain: true,
		width: 600,
		height: 400,
		layout: 'fit'
	},
	
	defaultFormConfig: {
		border: false,
		frame: true,
		autoHeight: true,
		labelAlign: 'right'
	},
	
	initModule: function() {
		Nexts.module.FormModule.superclass.initModule.call(this);
		
		this.on({
			activate: {
				fn: function() {
					this.form.setFocusItem(0);
				},
				scope: this,
				delay: 200
			}
		});
	},

	initConfig: function() {
		Nexts.module.FormModule.superclass.initConfig.call(this);
		
		this.formConfig = Ext.applyIf(this.formConfig || {}, this.defaultFormConfig);
	},
	
	createChild: function() {
		this.form = new (this.formType || Nexts.form.FormPanel)(this.formConfig);
		return this.form;
	},
	
	onCloseModule: function(m) {
		delete this.form;
		Nexts.module.FormModule.superclass.onCloseModule.apply(this, arguments);
	}
});

