if (typeof Ext.util.Format.escapeRegExp != 'function') {
	Ext.util.Format.escapeRegExp = String.escapeRegExp;
}

if (typeof Ext.util.Format.comboRenderer != 'function') {
	Ext.util.Format.comboRenderer = function(combo) {
		if (combo instanceof Ext.form.ComboBox) {
			return function(value) {
				var record = combo.findRecord(combo.valueField, value);
				return record ? record.get(combo.displayField) : value;
			}
		}
		else {
			function findRecord(prop, value) {
				var record;
				if (combo.store.getCount() > 0){
					combo.store.each(function(r){
				        if(r.data[prop] == value){
				            record = r;
				            return false;
				        }
				    });
				}
				return record;
			}
			
			return function(value) {
				var record = findRecord(combo.valueField, value);
				return record ? record.get(combo.displayField) : value;
			}
		}
	}
}

