Ext.ns('Nexts');

Nexts.VERSION = '1.2';

// firebug stubs
if (typeof(console) == 'undefined') {
	console = {};

	var cn = [
		"assert", "count", "debug", "dir", "dirxml", "error", "group",
		"groupEnd", "info", "log", "profile", "profileEnd", "time",
		"timeEnd", "trace", "warn"
	];
	var i = 0, tn;
	while ((tn = cn[i++])) {
		if (!console[tn]) {
			console[tn] = Ext.emptyFn;
		}
	}
}

// Nexts method
Nexts.findValue = function(name, scope) {
	if (!scope) {
		scope = window;
	}
	
	var ns = name.split('.');
	var v = scope;
	for (var i = 0; i < ns.length; i++) {
		v = v[ns[i]];
		if (v == null) {
			break;
		}
	}
	return v;
};

Nexts.clone = function(o) {
	if ('object' !== typeof o) {
		return o;
	}
	var c = 'function' === typeof o.pop ? [] : {};
	var p, v;
	for (p in o) {
		if (o.hasOwnProperty(p)) {
			v = o[p];
			if ('object' === typeof v) {
				c[p] = Nexts.clone(v);
			}
			else {
				c[p] = v;
			}
		}
	}
	return c;
};

Nexts.disableBackspace = function () {
	// prevent backspace (history -1) shortcut
	var map = new Ext.KeyMap(document, [{
		key: Ext.EventObject.BACKSPACE,
		fn: function(key, e) {
			var t = e.target.tagName;
			if (t != "INPUT" && t != "TEXTAREA") {
				e.stopEvent();
			}
		}
	}]);
};
