/*
 * This file is part of Nuts Framework.
 * Copyright (C) 2009 Nuts Develop Team.
 *
 * Nuts Framework is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License any later version.
 * 
 * Nuts Framework is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Nuts Framework. If not, see <http://www.gnu.org/licenses/>.
 */
package nuts.exts.xwork2.validator.validators;

import java.util.Collection;

import com.opensymphony.xwork2.validator.ValidationException;

/**
 * RequiredCollectionFieldValidator
 */
public class RequiredCollectionFieldValidator extends AbstractFieldValidator {
	protected Boolean trimNull;

	/**
	 * @return the trimNull
	 */
	public Boolean getTrimNull() {
		return trimNull;
	}

	/**
	 * @param trimNull the trimNull to set
	 */
	public void setTrimNull(Boolean trimNull) {
		this.trimNull = trimNull;
	}

	/**
	 * @see com.opensymphony.xwork2.validator.Validator#validate(java.lang.Object)
	 */
	public void validate(Object object) throws ValidationException {
		Object value = getFieldValue(getFieldName(), object);

		if (value == null) {
			addFieldError(getFieldName(), object);
			return;
		}

		if (!(value instanceof Collection)) {
			throw new ValidationException("filed [" + getFieldName() + "] (" + value.getClass()
					+ ") is not a instance of " + Collection.class);
		}

		Collection c = (Collection)value;
		if (c.isEmpty()) {
			addFieldError(getFieldName(), object);
			return;
		}

		if (Boolean.TRUE.equals(trimNull)) {
			for (Object o : c) {
				if (o != null) {
					return;
				}
			}
			addFieldError(getFieldName(), object);
		}
	}
}
