/*
 * This file is part of Nuts Framework.
 * Copyright (C) 2009 Nuts Develop Team.
 *
 * Nuts Framework is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License any later version.
 * 
 * Nuts Framework is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Nuts Framework. If not, see <http://www.gnu.org/licenses/>.
 */
package nuts.exts.xwork2;

import java.util.List;
import java.util.Map;


/**
 * TextProvider
 */
public interface TextProvider extends com.opensymphony.xwork2.TextProvider {
	/**
	 * getTextAsBoolean
	 * @param name resource name
	 * @return boolean value
	 */
	Boolean getTextAsBoolean(String name);

	/**
	 * getTextAsBoolean
	 * @param name resource name
	 * @param defaultValue default value
	 * @return boolean value
	 */
	Boolean getTextAsBoolean(String name, Boolean defaultValue);

	/**
	 * getTextAsInt
	 * @param name resource name
	 * @return integer value
	 */
	Integer getTextAsInt(String name);

	/**
	 * getTextAsInt
	 * @param name resource name
	 * @param defaultValue default value
	 * @return integer value
	 */
	Integer getTextAsInt(String name, Integer defaultValue);

	/**
	 * getTextAsLong
	 * @param name resource name
	 * @return long value
	 */
	Long getTextAsLong(String name);
	
	/**
	 * getTextAsLong
	 * @param name resource name
	 * @param defaultValue default value
	 * @return long value
	 */
	Long getTextAsLong(String name, Long defaultValue);

	/**
	 * getTextAsList
	 * @param name resource name
	 * @return list value
	 */
	List getTextAsList(String name);
	
	/**
	 * getTextAsList
	 * @param name resource name
	 * @param defaultValue default value
	 * @return list value
	 */
	List getTextAsList(String name, List defaultValue);

	/**
	 * getTextAsMap
	 * @param name resource name
	 * @return map value
	 */
	Map getTextAsMap(String name);
	
	/**
	 * getTextAsMap
	 * @param name resource name
	 * @param defaultValue default value
	 * @return map value
	 */
	Map getTextAsMap(String name, Map defaultValue);
}
