/*
 * This file is part of Nuts Framework.
 * Copyright (C) 2009 Nuts Develop Team.
 *
 * Nuts Framework is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License any later version.
 * 
 * Nuts Framework is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Nuts Framework. If not, see <http://www.gnu.org/licenses/>.
 */
package nuts.exts.xwork2;

import java.util.Collection;

import com.opensymphony.xwork2.ValidationAware;

/**
 * ActionValidationAware
 */
public interface ActionValidationAware extends ValidationAware {
    /**
     * Set the Collection of Action-level String warn messages.
     *
     * @param warnMessages
     */
    void setActionWarnings(Collection<String> warnMessages);

    /**
     * Get the Collection of Action-level warn messages for this action. Error messages should not
     * be added directly here, as implementations are free to return a new Collection or an
     * Unmodifiable Collection.
     *
     * @return Collection of String warn messages
     */
    Collection<String> getActionWarnings();

    /**
     * Add an Action-level warning message to this Action.
     * @param aWarnMessage the warning message
     */
    void addActionWarning(String aWarnMessage);

    /**
     * Check whether there are any Action-level warn messages.
     *
     * @return true if any Action-level warn messages have been registered
     */
	boolean hasActionWarnings();

    /**
     * Set the Collection of Action-level String confirm messages.
     *
     * @param confirmMessages
     */
    void setActionConfirms(Collection<String> confirmMessages);

    /**
     * Get the Collection of Action-level confirm messages for this action. Error messages should not
     * be added directly here, as implementations are free to return a new Collection or an
     * Unmodifiable Collection.
     *
     * @return Collection of String confirm messages
     */
    Collection<String> getActionConfirms();

    /**
     * Add an Action-level confirm message to this Action.
     * @param aConfirmMessage        the confirm message
     */
    void addActionConfirm(String aConfirmMessage);

    /**
     * Check whether there are any Action-level confirm messages.
     *
     * @return true if any Action-level confirm messages have been registered
     */
	boolean hasActionConfirms();

}
