/*
 * This file is part of Nuts Framework.
 * Copyright (C) 2009 Nuts Develop Team.
 *
 * Nuts Framework is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License any later version.
 *
 * Nuts Framework is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Nuts Framework. If not, see <http://www.gnu.org/licenses/>.
 */
package nuts.exts.struts2.views.java.simple;

import java.util.HashMap;
import java.util.Map;

import nuts.exts.struts2.views.java.DefaultTheme;
import nuts.exts.struts2.views.java.EmptyRenderer;
import nuts.exts.struts2.views.java.TemplateRendererFactory;

public class SimpleTheme extends DefaultTheme {
	public SimpleTheme() {
		setName("simple");

		Map<String, TemplateRendererFactory> rfs = new HashMap<String, TemplateRendererFactory>();
		rfs.put("a", new SimpleTemplateRendererFactory(EmptyRenderer.class));
		rfs.put("a-close", new SimpleTemplateRendererFactory(
				AnchorRenderer.class));
		rfs.put("actionerror", new SimpleTemplateRendererFactory(
				ActionErrorRenderer.class));
		rfs.put("actionmessage", new SimpleTemplateRendererFactory(
				ActionMessageRenderer.class));
		rfs.put("checkbox", new SimpleTemplateRendererFactory(
				CheckboxRenderer.class));
		rfs.put("checkboxlist", new SimpleTemplateRendererFactory(
				CheckboxListRenderer.class));
		rfs.put("div", new SimpleTemplateRendererFactory(DivRenderer.class));
		rfs.put("div-close", new SimpleTemplateRendererFactory(
				DivRenderer.Close.class));
		rfs.put("fielderror", new SimpleTemplateRendererFactory(
				FieldErrorRenderer.class));
		rfs.put("file", new SimpleTemplateRendererFactory(FileRenderer.class));
		rfs.put("form", new SimpleTemplateRendererFactory(FormRenderer.class));
		rfs.put("form-close", new SimpleTemplateRendererFactory(
				FormRenderer.Close.class));
		rfs.put("head", new SimpleTemplateRendererFactory(HeadRenderer.class));
		rfs.put("hidden", new SimpleTemplateRendererFactory(
				HiddenRenderer.class));
		rfs.put("label", new SimpleTemplateRendererFactory(LabelRenderer.class));
		rfs.put("password", new SimpleTemplateRendererFactory(
				PasswordRenderer.class));
		rfs.put("radiomap", new SimpleTemplateRendererFactory(RadioMapRenderer.class));
		rfs.put("reset", new SimpleTemplateRendererFactory(ResetRenderer.class));
		rfs.put("select", new SimpleTemplateRendererFactory(
				SelectRenderer.class));
		rfs.put("submit", new SimpleTemplateRendererFactory(
				SubmitRenderer.class));
		rfs.put("submit-close", new SimpleTemplateRendererFactory(
				SubmitRenderer.Close.class));
		rfs.put("text", new SimpleTemplateRendererFactory(
				TextFieldRenderer.class));
		rfs.put("textarea", new SimpleTemplateRendererFactory(
				TextAreaRenderer.class));
		rfs.put("token", new SimpleTemplateRendererFactory(TokenRenderer.class));

		//nuts template
		rfs.put("n-a", new SimpleTemplateRendererFactory(EmptyRenderer.class));
		rfs.put("n-a-close", new SimpleTemplateRendererFactory(
				NutsAnchorRenderer.class));
		rfs.put("n-actionconfirm", new SimpleTemplateRendererFactory(
				NutsActionConfirmRenderer.class));
		rfs.put("n-actionerror", new SimpleTemplateRendererFactory(
				NutsActionErrorRenderer.class));
		rfs.put("n-actionmessage", new SimpleTemplateRendererFactory(
				NutsActionMessageRenderer.class));
		rfs.put("n-actionwarning", new SimpleTemplateRendererFactory(
				NutsActionWarningRenderer.class));
		rfs.put("n-b", new SimpleTemplateRendererFactory(EmptyRenderer.class));
		rfs.put("n-b-close", new SimpleTemplateRendererFactory(
				NutsButtonRenderer.class));
		rfs.put("n-checkbox", new SimpleTemplateRendererFactory(
				NutsCheckboxRenderer.class));
		rfs.put("n-checkboxlist", new SimpleTemplateRendererFactory(
				NutsCheckboxListRenderer.class));
		rfs.put("n-datepicker", new SimpleTemplateRendererFactory(
				NutsDatePickerRenderer.class));
		rfs.put("n-datetimepicker", new SimpleTemplateRendererFactory(
				NutsDateTimePickerRenderer.class));
		rfs.put("n-fielderror", new SimpleTemplateRendererFactory(
				NutsFieldErrorRenderer.class));
		rfs.put("n-file", new SimpleTemplateRendererFactory(
				NutsFileRenderer.class));
		rfs.put("n-form", new SimpleTemplateRendererFactory(
				NutsFormRenderer.class));
		rfs.put("n-form-close", new SimpleTemplateRendererFactory(
				NutsFormRenderer.Close.class));
		rfs.put("n-hidden", new SimpleTemplateRendererFactory(
				NutsHiddenRenderer.class));
		rfs.put("n-link", new SimpleTemplateRendererFactory(
				NutsLinkRenderer.class));
		rfs.put("n-listview", new SimpleTemplateRendererFactory(
				NutsListViewRenderer.class));
		rfs.put("n-pager", new SimpleTemplateRendererFactory(
				NutsPagerRenderer.class));
		rfs.put("n-password", new SimpleTemplateRendererFactory(
				NutsPasswordRenderer.class));
		rfs.put("n-radiomap", new SimpleTemplateRendererFactory(
				NutsRadioMapRenderer.class));
		rfs.put("n-reset", new SimpleTemplateRendererFactory(
				NutsResetRenderer.class));
		rfs.put("n-reset-close", new SimpleTemplateRendererFactory(
				NutsResetRenderer.Close.class));
		rfs.put("n-select", new SimpleTemplateRendererFactory(
				NutsSelectRenderer.class));
		rfs.put("n-submit", new SimpleTemplateRendererFactory(
				NutsSubmitRenderer.class));
		rfs.put("n-submit-close", new SimpleTemplateRendererFactory(
				NutsSubmitRenderer.Close.class));
		rfs.put("n-textfield", new SimpleTemplateRendererFactory(
				NutsTextFieldRenderer.class));
		rfs.put("n-textarea", new SimpleTemplateRendererFactory(
				NutsTextAreaRenderer.class));
		rfs.put("n-timepicker", new SimpleTemplateRendererFactory(
				NutsTimePickerRenderer.class));
		rfs.put("n-triggerfield", new SimpleTemplateRendererFactory(
				NutsTriggerFieldRenderer.class));
		rfs.put("n-uploader", new SimpleTemplateRendererFactory(
				NutsUploaderRenderer.class));
		rfs.put("n-viewfield", new SimpleTemplateRendererFactory(
				NutsViewFieldRenderer.class));

		setRendererFactories(rfs);
	}
}
