/*
 * This file is part of Nuts Framework.
 * Copyright (C) 2009 Nuts Develop Team.
 *
 * Nuts Framework is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License any later version.
 *
 * Nuts Framework is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Nuts Framework. If not, see <http://www.gnu.org/licenses/>.
 */
package nuts.exts.struts2.views.java.nxhtml;

import org.apache.struts2.components.template.TemplateRenderingContext;

import nuts.exts.struts2.views.java.AbstractTemplateRenderer;
import nuts.exts.struts2.views.java.TemplateRenderer;

public abstract class NxhtmlTemplateRenderer extends AbstractTemplateRenderer {

	private TemplateRenderer simpleRenderer;

	/**
	 * @param context context
	 */
	public NxhtmlTemplateRenderer(TemplateRenderingContext context) {
		super(context);
	}
	
	/**
	 * @return the simpleRenderer
	 */
	public TemplateRenderer getSimpleRenderer() {
		return simpleRenderer;
	}

	/**
	 * @param simpleRenderer the simpleRenderer to set
	 */
	public void setSimpleRenderer(TemplateRenderer simpleRenderer) {
		this.simpleRenderer = simpleRenderer;
	}

	protected void renderSimple() throws Exception {
		simpleRenderer.render();
	}
}
