/*
 * This file is part of Nuts Framework.
 * Copyright (C) 2009 Nuts Develop Team.
 *
 * Nuts Framework is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License any later version.
 * 
 * Nuts Framework is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Nuts Framework. If not, see <http://www.gnu.org/licenses/>.
 */
package nuts.exts.struts2.components;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.struts2.views.annotations.StrutsTag;
import org.apache.struts2.views.annotations.StrutsTagAttribute;

import com.opensymphony.xwork2.util.ValueStack;

/**
 * <!-- START SNIPPET: javadoc --> Render a radio button input field.</p> <!-- END SNIPPET: javadoc
 * -->
 * <p/>
 * <b>Examples</b>
 * <p/>
 * <!-- START SNIPPET: exdescription --> In this example, a radio control is displayed with a list
 * of genders. The gender list is built from attribute id=genders. The framework calls getGenders()
 * which will return a Map. For examples using listKey and listValue attributes, see the section
 * select tag. The default selected one will be determined (in this case) by the getMale() method in
 * the action class which should retun a value similar to the key of the getGenters() map if that
 * particular gender is to be selected.
 * <p/>
 * <!-- END SNIPPET: exdescription -->
 * 
 * <pre>
 * &lt;!-- START SNIPPET: example --&gt;
 * &lt;s:action name=&quot;GenderMap&quot; var=&quot;genders&quot;/&gt;
 * &lt;s:radio label=&quot;Gender&quot; name=&quot;male&quot; list=&quot;#genders.genders&quot;/&gt;
 * &lt;!-- END SNIPPET: example --&gt;
 * </pre>
 */
@StrutsTag(
		name = "radio", 
		tldTagClass = "nuts.exts.struts2.views.jsp.ui.RadioTag", 
		description = "Renders a radio button input field",
		allowDynamicAttributes = true)
public class Radio extends ListUIBean {
	private final static String TEMPLATE = "n-radiomap";

	protected String headerKey;
	protected String headerValue;
	protected String readonly;

	/**
	 * Constructor
	 * 
	 * @param stack value stack
	 * @param request request
	 * @param response response
	 */
	public Radio(ValueStack stack, HttpServletRequest request, HttpServletResponse response) {
		super(stack, request, response);
	}

	protected String getDefaultTemplate() {
		return TEMPLATE;
	}

	/**
	 * evaluate extra parameters
	 */
	public void evaluateExtraParams() {
		super.evaluateExtraParams();

		if ((headerKey != null) && (headerValue != null)) {
			addParameter("headerKey", findString(headerKey));
			addParameter("headerValue", findString(headerValue));
		}

		if (readonly != null) {
			addParameter("readonly", findValue(readonly, Boolean.class));
		}
	}

	/**
	 * @param headerKey the headerKey to set
	 */
	@StrutsTagAttribute(description = " Key for first item in list. Must not be empty! '-1' and '' is correct, '' is bad.")
	public void setHeaderKey(String headerKey) {
		this.headerKey = headerKey;
	}

	/**
	 * @param headerValue the headerValue to set
	 */
	@StrutsTagAttribute(description = "Value expression for first item in list")
	public void setHeaderValue(String headerValue) {
		this.headerValue = headerValue;
	}

    /**
     * @param readonly the readonly to set
     */
    @StrutsTagAttribute(description="Whether the input is readonly", type="Boolean", defaultValue="false")
    public void setReadonly(String readonly) {
        this.readonly = readonly;
    }
}
