/*
 * This file is part of Nuts Framework.
 * Copyright (C) 2009 Nuts Develop Team.
 *
 * Nuts Framework is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License any later version.
 * 
 * Nuts Framework is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Nuts Framework. If not, see <http://www.gnu.org/licenses/>.
 */
package nuts.exts.struts2.components;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.struts2.views.annotations.StrutsTag;

import com.opensymphony.xwork2.util.ValueStack;


/**
 * <!-- START SNIPPET: javadoc -->
 *
 * Create a option transfer select component which is basically two &lt;select ...&gt;
 * tag with buttons in the middle of them allowing options in each of the
 * &lt;select ...&gt; to be moved between themselves. Will auto-select all its
 * elements upon its containing form submision.
 *
 * <!-- END SNIPPET: javadoc -->
 *
 * <p/>
 *
 *
 * <!-- START SNIPPET: notice -->
 *
 * NOTE: The id and doubleId need not be supplied as they will generated provided
 * that the optiontransferselect tag is being used in a form tag. The generated id
 * and doubleId will be &lt;form_id&gt;_&lt;optiontransferselect_doubleName&gt; and
 * &lt;form_id&gt;_&lt;optiontransferselect_doubleName&gt; respectively.
 *
 * <!-- END SNIPPET: notice -->
 *
 * <p/>
 *
 * <pre>
 * <!-- START SNIPPET: example -->
 *
 * &lt;-- minimum configuration --&gt;
 * &lt;s:optiontransferselect
 *      label="Favourite Cartoons Characters"
 *      name="leftSideCartoonCharacters"
 *      list="{'Popeye', 'He-Man', 'Spiderman'}"
 *      doubleName="rightSideCartoonCharacters"
 *      doubleList="{'Superman', 'Mickey Mouse', 'Donald Duck'}"
 *  /&gt;
 *
 *  &lt;-- possible configuration --&gt;
 *  &lt;n:optiontransferselect
 *      label="Favourite Cartoons Characters"
 *      name="leftSideCartoonCharacters"
 *      leftTitle="Left Title"
 *      rightTitle="Right Title"
 *      list="{'Popeye', 'He-Man', 'Spiderman'}"
 *      multiple="true"
 *      headerKey="headerKey"
 *      headerValue="--- Please Select ---"
 *      emptyOption="true"
 *      doubleList="{'Superman', 'Mickey Mouse', 'Donald Duck'}"
 *      doubleName="rightSideCartoonCharacters"
 *      doubleHeaderKey="doubleHeaderKey"
 *      doubleHeaderValue="--- Please Select ---"
 *      doubleEmptyOption="true"
 *      doubleMultiple="true"
 *  /&gt;
 *
 * <!-- END SNIPPET: example -->
 * </pre>
 *
 */@StrutsTag(
		name = "optiontransferselect", 
		tldTagClass = "nuts.exts.struts2.views.jsp.ui.OptionTransferSelectTag", 
		description = "Renders an input form", 
		allowDynamicAttributes = true)
public class OptionTransferSelect extends org.apache.struts2.components.OptionTransferSelect {
	/**
	 * Constructor
	 * 
	 * @param stack value stack
	 * @param request request
	 * @param response response
	 */
	public OptionTransferSelect(ValueStack stack, HttpServletRequest request, HttpServletResponse response) {
		super(stack, request, response);
		this.templateSuffix = "ftl";
	}
}
