/*
 * This file is part of Nuts Framework.
 * Copyright (C) 2009 Nuts Develop Team.
 *
 * Nuts Framework is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License any later version.
 * 
 * Nuts Framework is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Nuts Framework. If not, see <http://www.gnu.org/licenses/>.
 */
package nuts.exts.struts2.components;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.struts2.components.UIBean;
import org.apache.struts2.views.annotations.StrutsTag;
import org.apache.struts2.views.annotations.StrutsTagAttribute;

import com.opensymphony.xwork2.util.ValueStack;

/**
 * <!-- START SNIPPET: javadoc --> Renders an HTML input element of type hidden, populated by the
 * specified property from the ValueStack. <!-- END SNIPPET: javadoc -->
 * <p/>
 * <b>Examples</b>
 * 
 * <pre>
 * &lt;!-- START SNIPPET: example --&gt;
 * &lt;-- example one --&gt;
 * &lt;s:hidden name=&quot;foo&quot; /&gt;
 * &lt;-- example two --&gt;
 * &lt;s:hidden name=&quot;foo&quot; value=&quot;bar&quot; /&gt;
 * 
 * Example One Resulting HTML (if foo evaluates to bar):
 * &lt;input type=&quot;hidden&quot; name=&quot;foo&quot; value=&quot;bar&quot; /&gt;
 * Example Two Resulting HTML (if getBar method of the action returns 'bar')
 * &lt;input type=&quot;hidden&quot; name=&quot;foo&quot; value=&quot;bar&quot; /&gt;
 * &lt;!-- END SNIPPET: example --&gt;
 * </pre>
 */
@StrutsTag(
		name = "hidden", 
		tldTagClass = "nuts.exts.struts2.views.jsp.ui.HiddenTag", 
		description = "Render a hidden input field", 
		allowDynamicAttributes = true)
public class Hidden extends UIBean {
	private final static String TEMPLATE = "n-hidden";

	protected String format;

	/**
	 * Constructor
	 * 
	 * @param stack value stack
	 * @param request request
	 * @param response response
	 */
	public Hidden(ValueStack stack, HttpServletRequest request, HttpServletResponse response) {
		super(stack, request, response);
	}

	protected String getDefaultTemplate() {
		return TEMPLATE;
	}

    @SuppressWarnings("unchecked")
    protected Class getValueClassType() {
        return null;
    }
	/**
	 * evaluate extra parameters
	 */
	public void evaluateExtraParams() {
		super.evaluateExtraParams();

		if (format != null) {
			addParameter("format", findString(format));
		}
	}

	/**
	 * @param format the format to set
	 */
	@StrutsTagAttribute(description = "format attribute", type = "String")
	public void setFormat(String format) {
		this.format = format;
	}
}
