/*
 * This file is part of Nuts Framework.
 * Copyright (C) 2009 Nuts Develop Team.
 *
 * Nuts Framework is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License any later version.
 *
 * Nuts Framework is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Nuts Framework. If not, see <http://www.gnu.org/licenses/>.
 */
package nuts.exts.struts2.actions.ndfsfile;

import java.util.ArrayList;
import java.util.List;

import nuts.exts.struts2.actions.ModelDrivenAction;
import nuts.exts.vfs.ndfs.dao.NdfsDataDAO;
import nuts.exts.vfs.ndfs.dao.NdfsDataExample;
import nuts.exts.vfs.ndfs.dao.NdfsFile;
import nuts.exts.vfs.ndfs.dao.NdfsFileExample;

/**
 */
public class NdfsFileAction extends ModelDrivenAction<NdfsFile, NdfsFileExample> {
	private String ndfsDataModelName;
	private NdfsDataDAO ndfsDataDAO;

	/**
	 * Constructor
	 */
	public NdfsFileAction() {
	}

	/**
	 * @return the NdfsFile
	 */
	public NdfsFile getD() {
		return super.getData();
	}

	/**
	 * @param ndfsFile the ndfsFile to set
	 */
	public void setD(NdfsFile ndfsFile) {
		super.setData(ndfsFile);
	}

	/**
	 * @return the NdfsFile list
	 */
	public List<NdfsFile> getDs() {
		return super.getDataList();
	}

	/**
	 * @param ndfsFileList the ndfsFileList to set
	 */
	public void setDs(List<NdfsFile> ndfsFileList) {
		super.setDataList(ndfsFileList);
	}

	/**
	 * @return the ndfsDataModelName
	 */
	public String getNdfsDataModelName() {
		return ndfsDataModelName;
	}

	/**
	 * @param ndfsDataModelName the ndfsDataModelName to set
	 */
	public void setNdfsDataModelName(String ndfsDataModelName) {
		this.ndfsDataModelName = ndfsDataModelName;
	}

	/**
	 * @return the ndfsDataDAO
	 */
	protected NdfsDataDAO getNdfsDataDAO() {
		if (ndfsDataDAO == null) {
			ndfsDataDAO = createNdfsDataDAO();
		}
		return ndfsDataDAO;
	}

	protected NdfsDataDAO createNdfsDataDAO() {
		return (NdfsDataDAO)getDataAccessSession().getModelDAO(ndfsDataModelName);
	}
	
	/**
	 * @param ndfsDataDAO the ndfsDataDAO to set
	 */
	protected void setNdfsDataDAO(NdfsDataDAO ndfsDataDAO) {
		this.ndfsDataDAO = ndfsDataDAO;
	}

	/**
	 * prepareDefaultData
	 * @param data data
	 * @return data
	 */
	protected NdfsFile prepareDefaultData(NdfsFile data) throws Exception {
		if (data == null) {
			data = new NdfsFile();
		}
		return data;
	}

	/**
	 * list
	 * @return SUCCESS
	 * @throws Exception if an error occurs
	 */
	public String list() throws Exception {
		if (get_save() == null) {
			set_save(true);
		}
		return doList();
	}
	
	/**
	 * list_csv
	 * @return SUCCESS
	 * @throws Exception if an error occurs
	 */
	public String list_csv() throws Exception {
		if (get_save() == null) {
			set_save(false);
		}
		return doList();
	}
	
	/**
	 * list_print
	 * @return SUCCESS
	 * @throws Exception if an error occurs
	 */
	public String list_print() throws Exception {
		if (get_save() == null) {
			set_save(false);
		}
		return doList();
	}
	
	/**
	 * list_popup
	 * @return SUCCESS
	 * @throws Exception if an error occurs
	 */
	public String list_popup() throws Exception {
		addLimitToPager(DEFAULT_POPUP_PAGER_LIMIT);
		if (get_save() == null) {
			set_save(false);
		}
		return doList();
	}
	
	/**
	 * bdelete
	 * @return SUCCESS
	 * @throws Exception if an error occurs
	 */
	public String bdelete() throws Exception {
		return doBulkDeleteSelect();
	}

	/**
	 * bdeleteExecute
	 * @return SUCCESS
	 * @throws Exception if an error occurs
	 */
	public String bdeleteExecute() throws Exception {
		return doBulkDeleteExecute();
	}

	/**
	 * view
	 * @return SUCCESS
	 * @throws Exception if an error occurs
	 */
	public String view() throws Exception {
		return doViewSelect();
	}
	
	/**
	 * viewInput
	 * @return SUCCESS
	 * @throws Exception if an error occurs
	 */
	public String viewInput() throws Exception {
		return doViewInput();
	}

	/**
	 * print
	 * @return SUCCESS
	 * @throws Exception if an error occurs
	 */
	public String print() throws Exception {
		return doViewSelect();
	}

	/**
	 * print
	 * @return SUCCESS
	 * @throws Exception if an error occurs
	 */
	public String printInput() throws Exception {
		return doViewSelect();
	}

	/**
	 * insert
	 * @return SUCCESS
	 * @throws Exception if an error occurs
	 */
	public String insert() throws Exception {
		return doInsertClear();
	}

	/**
	 * insertInput
	 * @return SUCCESS
	 * @throws Exception if an error occurs
	 */
	public String insertInput() throws Exception {
		return doInsertInput();
	}

	/**
	 * insertConfirm
	 * @return SUCCESS
	 * @throws Exception if an error occurs
	 */
	public String insertConfirm() throws Exception {
		return doInsertConfirm();
	}

	/**
	 * insertExecute
	 * @return SUCCESS
	 * @throws Exception if an error occurs
	 */
	public String insertExecute() throws Exception {
		return doInsertExecute();
	}

	/**
	 * copy
	 * @return SUCCESS
	 * @throws Exception if an error occurs
	 */
	public String copy() throws Exception {
		return doInsertSelect();
	}

	/**
	 * copyInput
	 * @return SUCCESS
	 * @throws Exception if an error occurs
	 */
	public String copyInput() throws Exception {
		return doInsertInput();
	}

	/**
	 * copyConfirm
	 * @return SUCCESS
	 * @throws Exception if an error occurs
	 */
	public String copyConfirm() throws Exception {
		return doInsertConfirm();
	}

	/**
	 * copyExecute
	 * @return SUCCESS
	 * @throws Exception if an error occurs
	 */
	public String copyExecute() throws Exception {
		return doInsertExecute();
	}

	/**
	 * update
	 * @return SUCCESS
	 * @throws Exception if an error occurs
	 */
	public String update() throws Exception {
		return doUpdateSelect();
	}

	/**
	 * updateInput
	 * @return SUCCESS
	 * @throws Exception if an error occurs
	 */
	public String updateInput() throws Exception {
		return doUpdateInput();
	}

	/**
	 * updateConfirm
	 * @return SUCCESS
	 * @throws Exception if an error occurs
	 */
	public String updateConfirm() throws Exception {
		return doUpdateConfirm();
	}

	/**
	 * updateExecute
	 * @return SUCCESS
	 * @throws Exception if an error occurs
	 */
	public String updateExecute() throws Exception {
		return doUpdateExecute();
	}

	/**
	 * delete
	 * @return SUCCESS
	 * @throws Exception if an error occurs
	 */
	public String delete() throws Exception {
		return doDeleteSelect();
	}

	/**
	 * deleteExecute
	 * @return SUCCESS
	 * @throws Exception if an error occurs
	 */
	public String deleteExecute() throws Exception {
		return doDeleteExecute();
	}

	/**
	 * startDelete
	 * @param data data
	 */
	@Override
	protected void startDelete(NdfsFile data) throws Exception {
		super.startDelete(data);

		NdfsDataExample dexp = getNdfsDataDAO().createExample();
		dexp.fileId().equalTo(data.getId());
		getNdfsDataDAO().deleteByExample(dexp);
	}

	/**
	 * startBulkDelete
	 * @param dataList dataList
	 */
	@Override
	protected void startBulkDelete(List<NdfsFile> dataList) throws Exception {
		super.startBulkDelete(dataList);
		
		NdfsDataExample dexp = getNdfsDataDAO().createExample();
		List<Long> ids = new ArrayList<Long>(dataList.size());
		for (NdfsFile f : dataList) {
			ids.add(f.getId());
		}
		dexp.fileId().in(ids);
		getNdfsDataDAO().deleteByExample(dexp);
	}
}
