/*
 * This file is part of Nuts Framework.
 * Copyright (C) 2009 Nuts Develop Team.
 *
 * Nuts Framework is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License any later version.
 * 
 * Nuts Framework is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Nuts Framework. If not, see <http://www.gnu.org/licenses/>.
 */
package nuts.exts.struts2.actions;

import java.io.IOException;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import nuts.core.servlet.HttpServletSupport;
import nuts.exts.fileupload.UploadFile;

import org.apache.commons.vfs.FileContent;

/**
 * File download/upload for temporary image
 */
@SuppressWarnings("serial")
public class FileServeAction extends CommonServletAction {

	protected UploadFile file = new UploadFile();

	protected int bufferSize = 4096;
	protected boolean cache = true;
	protected boolean attachment = true;


	/**
	 * @return the file
	 */
	public UploadFile getFile() {
		return file;
	}

	/**
	 * @param file the file to set
	 */
	public void setFile(UploadFile file) {
		this.file = file;
	}

	/**
	 * @return the cache
	 */
	public boolean isCache() {
		return cache;
	}

	/**
	 * @param cache the cache to set
	 */
	public void setCache(boolean cache) {
		this.cache = cache;
	}

	/**
	 * @return the bufferSize
	 */
	public int getBufferSize() {
		return bufferSize;
	}

	/**
	 * @param bufferSize the bufferSize to set
	 */
	public void setBufferSize(int bufferSize) {
		this.bufferSize = bufferSize;
	}

	/**
	 * @return the attachment
	 */
	public boolean isAttachment() {
		return attachment;
	}

	/**
	 * @param attachment the attachment to set
	 */
	public void setAttachment(boolean attachment) {
		this.attachment = attachment;
	}

	/**
	 * @return the filename
	 * @throws IOException IOException
	 */
	public String getFn() throws IOException {
		return file.getSaveName();
	}

	/**
	 * @param filename the filename to set
	 * @throws IOException IOException
	 */
	public void setFn(String filename) throws IOException {
		file.setSaveName(filename);
	}

	/**
	 * execute
	 * 
	 * @return result name
	 * @throws Exception if an error occurs
	 */
	public String execute() throws Exception {
		return SUCCESS;
	}
	
	/**
	 * upload
	 * 
	 * @return NONE
	 * @throws Exception if an error occurs
	 */
	public String upload() throws Exception {
		return SUCCESS;
	}
	
	/**
	 * download
	 * 
	 * @return NONE
	 * @throws Exception if an error occurs
	 */
	public String download() throws Exception {
		if (file.getFile() == null) {
			return NONE;
		}

		HttpServletRequest servletRequest = getServletRequest();
		HttpServletResponse servletResponse = getServletResponse();

		FileContent fc = file.getFile().getContent();
		String filename = file.getFile().getName().getBaseName();
		
		HttpServletSupport hsrs = new HttpServletSupport(servletRequest, servletResponse);
		
		hsrs.setContentLength(Integer.valueOf((int)fc.getSize()));
		hsrs.setFileName(filename);
		hsrs.setNoCache(!cache);

		hsrs.writeResponseHeader();
		hsrs.writeResponseData(fc.getInputStream(), bufferSize);
		
		return NONE;
	}

}
