/*
 * This file is part of Nuts Framework.
 * Copyright (C) 2009 Nuts Develop Team.
 *
 * Nuts Framework is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License any later version.
 * 
 * Nuts Framework is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Nuts Framework. If not, see <http://www.gnu.org/licenses/>.
 */
package nuts.exts.struts2.actions;

import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import nuts.exts.struts2.util.StrutsContextUtils;

import org.apache.struts2.interceptor.PrincipalAware;
import org.apache.struts2.interceptor.PrincipalProxy;
import org.apache.struts2.interceptor.ServletRequestAware;
import org.apache.struts2.interceptor.ServletResponseAware;
import org.apache.struts2.util.ServletContextAware;

/**
 * CommonHttpAction
 */
@SuppressWarnings("serial")
public class CommonServletAction extends CommonAction implements ServletContextAware,
		ServletRequestAware, ServletResponseAware, PrincipalAware {

	/*------------------------------------------------------------
	 * aware implements
	 *------------------------------------------------------------*/
	private ServletContext servletContext;
	private HttpServletRequest servletRequest;
	private HttpServletResponse servletResponse;
	private PrincipalProxy principalProxy;

	/**
	 * @return the servletContext
	 */
	public ServletContext getServletContext() {
		if (servletContext == null) {
			servletContext = StrutsContextUtils.getServletContext();
		}
		return servletContext;
	}

	/**
	 * @param servletContext the servletContext to set
	 */
	public void setServletContext(ServletContext servletContext) {
		this.servletContext = servletContext;
	}

	/**
	 * @return the servletRequest
	 */
	public HttpServletRequest getServletRequest() {
		if (servletRequest == null) {
			servletRequest = StrutsContextUtils.getServletRequest();
		}
		return servletRequest;
	}

	/**
	 * @param servletRequest the servletRequest to set
	 */
	public void setServletRequest(HttpServletRequest servletRequest) {
		this.servletRequest = servletRequest;
	}

	/**
	 * @return the servletResponse
	 */
	public HttpServletResponse getServletResponse() {
		if (servletResponse == null) {
			servletResponse = StrutsContextUtils.getServletResponse();
		}
		return servletResponse;
	}

	/**
	 * @param servletResponse the servletResponse to set
	 */
	public void setServletResponse(HttpServletResponse servletResponse) {
		this.servletResponse = servletResponse;
	}

	/**
	 * @return the principalProxy
	 */
	public PrincipalProxy getPrincipalProxy() {
		if (principalProxy == null) {
			principalProxy = StrutsContextUtils.getPrincipalProxy();
		}
		return principalProxy;
	}

	/**
	 * @param principalProxy the principalProxy to set
	 */
	public void setPrincipalProxy(PrincipalProxy principalProxy) {
		this.principalProxy = principalProxy;
	}

}
