/*
 * This file is part of Nuts Framework.
 * Copyright (C) 2009 Nuts Develop Team.
 *
 * Nuts Framework is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License any later version.
 * 
 * Nuts Framework is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Nuts Framework. If not, see <http://www.gnu.org/licenses/>.
 */
package nuts.exts.mybatis;

import java.util.Properties;

import javax.sql.DataSource;

import nuts.core.orm.dao.AbstractDataAccessClient;
import nuts.core.orm.dao.DataAccessException;
import nuts.core.orm.dao.DataAccessSession;

import org.apache.ibatis.session.SqlSessionFactory;

/**
 */
public class MyBatisDataAccessClient extends AbstractDataAccessClient implements SqlSessionFactoryAware {
	private SqlSessionFactory sqlSessionFactory;
	
	/**
	 */
	public MyBatisDataAccessClient() {
		super();
	}

	/**
	 * @param sqlSessionFactory the sqlSessionFactory to set
	 * @param props the props to set
	 */
	public MyBatisDataAccessClient(SqlSessionFactory sqlSessionFactory, Properties props) {
		super(props);
		this.sqlSessionFactory = sqlSessionFactory;
	}

	/**
	 * @return the sqlSessionFactory
	 */
	public SqlSessionFactory getSqlSessionFactory() {
		return sqlSessionFactory;
	}

	/**
	 * @param sqlSessionFactory the sqlSessionFactory to set
	 */
	public void setSqlSessionFactory(SqlSessionFactory sqlSessionFactory) {
		this.sqlSessionFactory = sqlSessionFactory;
	}

	/**
	 * @return DataSource
	 */
	public DataSource getDataSource() {
		return sqlSessionFactory.getConfiguration().getEnvironment().getDataSource();
	}

	/**
	 * open session
	 * @param autoCommit auto commit
	 */
	public DataAccessSession openSession(boolean autoCommit) throws DataAccessException {
		return new MyBatisDataAccessSession(this, autoCommit);
	}
}
