/*
 * This file is part of Nuts Framework.
 * Copyright (C) 2009 Nuts Develop Team.
 *
 * Nuts Framework is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License any later version.
 * 
 * Nuts Framework is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Nuts Framework. If not, see <http://www.gnu.org/licenses/>.
 */
package nuts.exts.json.processors;

import net.sf.json.JSONNull;
import net.sf.json.JSONObject;
import net.sf.json.JsonConfig;
import net.sf.json.processors.JsonValueProcessor;
import nuts.exts.fileupload.UploadFile;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/**
 */
public class UploadFileValueProcessor implements JsonValueProcessor {
	
	protected static final Log log = LogFactory.getLog(UploadFileValueProcessor.class);

	/**
	 * Constructor
	 */
	public UploadFileValueProcessor() {
	}

	/**
	 * @see net.sf.json.processors.JsonValueProcessor#processArrayValue(java.lang.Object, net.sf.json.JsonConfig)
	 */
	public Object processArrayValue(Object value, JsonConfig jsonConfig) {
		return value;
	}

	/**
	 * @see net.sf.json.processors.JsonValueProcessor#processObjectValue(java.lang.String, java.lang.Object, net.sf.json.JsonConfig)
	 */
	public Object processObjectValue(String key, Object value, JsonConfig jsonConfig) {
		if (value == null) {
			return JSONNull.getInstance();
		}
		
		if (!(value instanceof UploadFile)) {
			throw new IllegalArgumentException();
		}

		UploadFile uf = (UploadFile)value;
		
		JSONObject jo = new JSONObject();
		
		jo.put("contentType", uf.getContentType());
		jo.put("fileName", uf.getFileName());
		jo.put("fileSize", uf.getFileSize());
		jo.put("saveName", uf.getSaveName());
		jo.put("saveTime", uf.getSaveTime());

		return jo;
	}
}

