/*
 * This file is part of Nuts Framework.
 * Copyright (C) 2009 Nuts Develop Team.
 *
 * Nuts Framework is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License any later version.
 * 
 * Nuts Framework is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Nuts Framework. If not, see <http://www.gnu.org/licenses/>.
 */
package nuts.exts.json.processors;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

import net.sf.json.JSONNull;
import net.sf.json.JsonConfig;
import net.sf.json.processors.JsonValueProcessor;
import ognl.DefaultTypeConverter;

/**
 * Use TypeConverter to convert Date Type Value 
 */
public class DateValueProcessor implements JsonValueProcessor {
	private DefaultTypeConverter dateTypeConverter;
	private SimpleDateFormat dateFormat;
	private boolean toTime;

	/**
	 * Constructor
	 */
	public DateValueProcessor() {
	}

	/**
	 * @param dateTypeConverter the dateTypeConverter to set
	 */
	public void setDateTypeConverter(DefaultTypeConverter dateTypeConverter) {
		this.dateTypeConverter = dateTypeConverter;
	}

	/**
	 * @param dateFormat the dateFormat to set
	 */
	public void setDateFormat(String dateFormat) {
		this.dateFormat = new SimpleDateFormat(dateFormat);
	}

	/**
	 * @param toTime the toTime to set
	 */
	public void setToTime(boolean toTime) {
		this.toTime = toTime;
	}

	/**
	 * @see net.sf.json.processors.JsonValueProcessor#processArrayValue(java.lang.Object, net.sf.json.JsonConfig)
	 */
	public Object processArrayValue(Object value, JsonConfig jsonConfig) {
		return value;
	}

	/**
	 * @see net.sf.json.processors.JsonValueProcessor#processObjectValue(java.lang.String, java.lang.Object, net.sf.json.JsonConfig)
	 */
	public Object processObjectValue(String key, Object value, JsonConfig jsonConfig) {
		if (value == null) {
			return JSONNull.getInstance();
		}

		if (value instanceof Calendar) {
			value = ((Calendar)value).getTime(); 
		}
		else if (!(value instanceof Date)) {
			throw new IllegalArgumentException("The value[" + value.getClass() + "] must be Date/Calendar type.");
		}

		if (dateTypeConverter != null) {
			return dateTypeConverter.convertValue(null, value, String.class);
		}
		else if (dateFormat != null){
			return dateFormat.format(value);
		}
		else if (toTime) {
			return ((Date)value).getTime();
		}
		else {
			return value;
		}
	}
}

