/*
 * This file is part of Nuts Framework.
 * Copyright (C) 2009 Nuts Develop Team.
 *
 * Nuts Framework is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License any later version.
 *
 * Nuts Framework is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Nuts Framework. If not, see <http://www.gnu.org/licenses/>.
 */
package nuts.exts.ibatis.type;

import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;

import net.sf.json.JSONObject;

import nuts.core.lang.StringUtils;

import com.ibatis.sqlmap.engine.type.BaseTypeHandler;

/**
 * List implementation of TypeHandler
 */
public class MapTypeHandler extends BaseTypeHandler {

	/**
	 * @see com.ibatis.sqlmap.engine.type.TypeHandler#setParameter(java.sql.PreparedStatement, int, java.lang.Object, java.lang.String)
	 */
	public void setParameter(PreparedStatement ps, int i, Object parameter,
			String jdbcType) throws SQLException {
		String val = null;
		if (parameter != null) {
			val = JSONObject.fromObject(parameter).toString();
		}
		ps.setString(i, val);
	}

	protected Object toMap(String v) {
		if (StringUtils.isEmpty(v)) {
			return new HashMap();
		}
		else {
			return JSONObject.toBean(JSONObject.fromObject(v), HashMap.class);
		}
	}

	/**
	 * @see com.ibatis.sqlmap.engine.type.TypeHandler#getResult(java.sql.ResultSet, java.lang.String)
	 */
	public Object getResult(ResultSet rs, String columnName)
			throws SQLException {
		String s = rs.getString(columnName);
		if (rs.wasNull()) {
			return null;
		}
		else {
			return toMap(s);
		}
	}

	/**
	 * @see com.ibatis.sqlmap.engine.type.TypeHandler#getResult(java.sql.ResultSet, int)
	 */
	public Object getResult(ResultSet rs, int columnIndex) throws SQLException {
		String s = rs.getString(columnIndex);
		if (rs.wasNull()) {
			return null;
		}
		else {
			return toMap(s);
		}
	}

	/**
	 * @see com.ibatis.sqlmap.engine.type.TypeHandler#getResult(java.sql.CallableStatement, int)
	 */
	public Object getResult(CallableStatement cs, int columnIndex)
			throws SQLException {
		String s = cs.getString(columnIndex);
		if (cs.wasNull()) {
			return null;
		}
		else {
			return toMap(s);
		}
	}

	/**
	 * @see com.ibatis.sqlmap.engine.type.TypeHandler#valueOf(java.lang.String)
	 */
	public Object valueOf(String s) {
		return s;
	}

}
