/*
 * This file is part of Nuts Framework.
 * Copyright(C) 2009-2012 Nuts Develop Team.
 *
 * Nuts Framework is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License any later version.
 *
 * Nuts Framework is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Nuts Framework. If not, see <http://www.gnu.org/licenses/>.
 */
package nuts.demo.action.sample;

import java.util.List;

import nuts.core.orm.dao.DataAccessException;
import nuts.demo.action.samplefile.SampleFileAction;
import nuts.demo.model.bean.SampleFile;
import nuts.demo.model.example.SampleFileExample;



/**
 */
public class SampleFileExAction extends SampleFileAction {

	public SampleFileExAction() {
		this.setUpdateSelective(true);
	}

	/**
	 * @see nuts.exts.struts2.actions.ModelDrivenAction#daoSelectByPrimaryKey(java.lang.Object)
	 */
	@Override
	protected SampleFile daoSelectByPrimaryKey(SampleFile key) throws DataAccessException {
		SampleFileExample exp = daoCreateExample();
		exp.id().equalTo(key.getId()).fileField().exclude().imageField().exclude();
		return getModelDAO().selectOneByExample(exp);
	}

	/**
	 * @see nuts.exts.struts2.actions.ModelDrivenAction#daoSelectByExample(nuts.core.orm.dao.QueryParameter)
	 */
	@Override
	protected List<SampleFile> daoSelectByExample(SampleFileExample exp) throws Exception {
		exp.fileField().exclude().imageField().exclude();
		return super.daoSelectByExample(exp);
	}
}
