/*
 * This file is part of Nuts Framework.
 * Copyright(C) 2009-2012 Nuts Develop Team.
 *
 * Nuts Framework is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License any later version.
 *
 * Nuts Framework is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Nuts Framework. If not, see <http://www.gnu.org/licenses/>.
 */
package nuts.demo;

import java.io.File;

import nuts.aems.WebApplet;

import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.util.Version;

/**
 * Application
 */
public class Application extends WebApplet {

	private static File lucenePath;
	private static Directory luceneDirectory;
	
	/**
	 * @return the luceneDirectory
	 */
	public static Directory getLuceneDirectory() {
		return luceneDirectory;
	}

	/**
	 * @return the luceneIndexWriter
	 */
	public static IndexWriter getLuceneIndexWriter() throws Exception {
		IndexWriter writer = new IndexWriter(Application.getLuceneDirectory(),
			new StandardAnalyzer(Version.LUCENE_30), !lucenePath.exists(),
			IndexWriter.MaxFieldLength.LIMITED);
		return writer;
	}

	@Override
	protected void initialize() throws Exception {
		super.initialize();
		
		lucenePath = new File(Application.get().getPropertyAsPath("lucene.directory", "/WEB-INF/lucene"));
		luceneDirectory = FSDirectory.open(lucenePath);
	}
}
