/*
 * This file is part of Nuts.
 * Copyright (C) 2009 Nuts Develop Team.
 *
 * Nuts is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License any later version.
 *
 * Nuts is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Nuts. If not, see <http://www.gnu.org/licenses/>.
 */
package nuts.demo.model.dao;

import java.util.List;

import nuts.core.orm.dao.DataAccessSession;
import nuts.core.orm.dao.DataAccessUtils;
import nuts.demo.Application;
import nuts.demo.model.bean.SampleTags;
import nuts.demo.model.example.SampleTagsExample;
import nuts.demo.test.ActionTestCase;

public class SampleTagsDAOTest extends ActionTestCase {
	private DataAccessSession session;
	
	@Override
	protected void setUp() throws Exception {
		session = Application.get().getDataAccessClient().openSession();
		super.setUp();
	}

	@Override
	protected void tearDown() throws Exception {
		DataAccessUtils.closeQuietly(session);
		super.tearDown();
	}

	public void testSelectByPrimaryKey() throws Exception {
		SampleTagsDAO dao = new SampleTagsDAO(session);
		
		dao.selectByPrimaryKey(1L);
		
		session.commit();
	}

	public void testDeleteByPrimaryKey() throws Exception {
		SampleTagsDAO dao = new SampleTagsDAO(session);
		
		dao.deleteByPrimaryKey(1L);
		
		session.commit();
	}

	public void testUpdateByPrimaryKey() throws Exception {
		SampleTagsDAO dao = new SampleTagsDAO(session);
		
		SampleTags s1 = new SampleTags();
		s1.setId(1L);
		
		dao.updateByPrimaryKey(s1);
		
		session.commit();
	}

	public void testUpdateByPrimaryKeySelective() throws Exception {
		SampleTagsDAO dao = new SampleTagsDAO(session);
		
		SampleTags s1 = new SampleTags();
		s1.setId(1L);
		s1.setBbcodeField("test");
		
		dao.updateByPrimaryKey(s1);
		
		session.commit();
	}

	public void testSelectByExample() throws Exception {
		SampleTagsDAO dao = new SampleTagsDAO(session);
		
		SampleTagsExample exp = dao.createExample();
		
		exp.name().exclude()
			.id().equalTo(1L)
			.name().lessThan("2")
			.intField().between(100, 1000)
			.dateField().isNull()
			;

		List<SampleTags> list = dao.selectByExample(exp);
		
		for (SampleTags s : list) {
			assertNotNull(s.getName());
		}
		
		session.commit();
	}

	public void testSelectByExample2() throws Exception {
		SampleTagsDAO dao = new SampleTagsDAO(session);
		
		SampleTagsExample exp = dao.createExample();
		
		exp.excludeALL().name().include()
			.name().in(new String[] { "t3", "t4", "t5" })
			;

		List<SampleTags> list = dao.selectByExample(exp);
		
		for (SampleTags s : list) {
			assertNotNull(s.getName());
		}
		
		session.commit();
	}

	public void testUpdateByExample() throws Exception {
		SampleTagsDAO dao = new SampleTagsDAO(session);
		
		SampleTags s1 = new SampleTags();
		s1.setId(1L);

		SampleTagsExample exp = dao.createExample();
		exp.name().exclude()
			.id().equalTo(1L)
			.name().lessThan("2")
			.intField().between(100, 1000)
			.htmlField().greaterThan("3")
			.bbcodeField().lessThan("4")
			.dateField().isNull()
		;

		dao.updateByExample(s1, exp);
		
		session.commit();
	}
}
