package nuts.core.util.convert;

import nuts.core.lang.ObjectUtils;
import nuts.core.lang.StringUtils;

import java.util.Arrays;
import java.util.List;

import junit.framework.TestCase;

/**
 */
public class ConvertTest extends TestCase {
	public void testStringArrayToIntArray() throws Exception {
		String[] ss = {
			"1", "2", "-3", "a"
		};
		
		int[] ii = {
			1, 2, -3, 0
		};
		
		assertEquals(StringUtils.join(ii), StringUtils.join(ObjectUtils.convert(ss, int[].class)));
		assertTrue(Arrays.equals(ii, ObjectUtils.convert(ss, int[].class)));
	}

	@SuppressWarnings("unchecked")
	public void testStringArrayToIntList() throws Exception {
		String[] ss = {
			"1", "2", "-3", "a"
		};
		
		Integer[] ii = {
			1, 2, -3, 0
		};
		
		List<Integer> il = ObjectUtils.convert(ss, List.class, Integer.TYPE);
		Integer[] iii = il.toArray(new Integer[0]);
		
		assertEquals(StringUtils.join(ii), StringUtils.join(il));
		assertTrue(Arrays.equals(ii, iii));
	}
}
