/*
 * This file is part of Nuts Framework.
 * Copyright(C) 2009-2012 Nuts Develop Team.
 *
 * Nuts Framework is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License any later version.
 * 
 * Nuts Framework is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Nuts Framework. If not, see <http://www.gnu.org/licenses/>.
 */
package nuts.core.util;

import java.security.Provider;
import java.security.Provider.Service;
import java.security.Security;

import junit.framework.TestCase;

/**
 * test class for StringUtils
 */
public class StringCryptoUtilsTest extends TestCase {

	/**
	 */
	public void testProviders() throws Exception {
		for (Provider p : Security.getProviders()) {
			System.out.println(p.getName());
			System.out.println("------------------------------");
			for (Service s : p.getServices()) {
				System.out.println(s.getAlgorithm());
			}
			System.out.println("------------------------------");
		}
	}

	private void encdec(String key, String trans) throws Exception {
		System.out.println("-----------" + trans + "-------------------");

		String text = "trustme";

		String enc = StringCryptoUtils.encrypt(text, key, trans);
		System.out.println("encrypt [" + text + "] --> [" + enc + "]");

		String dec = StringCryptoUtils.decrypt(enc, key, trans);
		System.out.println("decrypt [" + enc + "] --> [" + dec + "]");
		
		assertEquals(text, dec);
	}

	public void testBlowfish() throws Exception {
		encdec("nuts", "Blowfish");
	}

//	public void testDES() throws Exception {
//		encdec("1234567", "DES");
//	}

	public void testAES() throws Exception {
		encdec("1234567890123456", "AES");
	}
}
