package nuts.core.sql;

import java.util.List;

import nuts.core.sql.SqlUtils;

import junit.framework.TestCase;

/**
 * Test class for SqlUtils
 * @see SqlUtils
 */
public class SqlUtilsTest extends TestCase {

	/**
	 * test @link {@link SqlUtils#parseSql(String, char)}
	 */
	public void testParseSql() {
		String sql = "INSERT INTO RESOURCE VALUES(null, #clazz#, #language#, null, '0''0', '#aa#', now(), 0)";
		
		List<String> list = SqlUtils.parseSql(sql, '#');
	
		assertEquals(3, list.size());
		assertEquals("INSERT INTO RESOURCE VALUES(null, ?, ?, null, '0''0', '#aa#', now(), 0)", list.get(0));
		assertEquals("clazz", list.get(1));
		assertEquals("language", list.get(2));
	}

}
