/*
 * This file is part of Nuts Framework.
 * Copyright(C) 2009-2012 Nuts Develop Team.
 *
 * Nuts Framework is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License any later version.
 * 
 * Nuts Framework is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Nuts Framework. If not, see <http://www.gnu.org/licenses/>.
 */
package nuts.core.net;

import java.util.List;

import nuts.core.net.MXLookup;

import junit.framework.TestCase;

/**
 * test class for MXLookup
 * @see MXLookup
 */
public class MXLookupTest extends TestCase {

	/**
	 * @see MXLookup#lookup(String)
	 */
	public void testLookup() {
		String[] args = new String[] {
				"hotmail.com", "yahoo.com", "gmail.com"
		};
		for (int i = 0; i < args.length; i++) {
			try {
				List<String> hosts = MXLookup.lookup(args[i]);
				assertTrue(hosts.size() > 0);
				for (int j = 0; j < hosts.size(); j++) {
					System.out.println(args[i] + "[" + j + "]: " + hosts.get(j));
				}
			}
			catch (Exception e) {
				e.printStackTrace();
				fail(e.getMessage());
				return;
			}
		}
	}

}
