/*
 * This file is part of Nuts Framework.
 * Copyright(C) 2009-2012 Nuts Develop Team.
 *
 * Nuts Framework is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License any later version.
 * 
 * Nuts Framework is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Nuts Framework. If not, see <http://www.gnu.org/licenses/>.
 */
package nuts.core.lang;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;

import junit.framework.TestCase;

/**
 * test class for StringUtils
 */
public class TextUtilsTest extends TestCase {
	/**
	 * test method: transform
	 * @throws Exception if an error occurs
	 */
	public void testTransform() throws Exception {
		Map<String, String> m = new HashMap<String, String>();
		m.put("a", "1");
		m.put("a.b", "2");
		m.put("a.b.c", "3");
		
		assertEquals("1.23-${8}-xx", TextUtils.transform("${a}.${a.b}${a.b.c}-${8}-xx", m));
	}

	/**
	 * test method: parseKeywords
	 * @throws Exception if an error occurs
	 */
	public void testParseKeyword() throws Exception {
		String text = "abc1 adf - <>/ @ おあい";
		
		Set<String> kws = TextUtils.parseKeywords(text);
		for (String s : kws) {
			System.out.println(s);
		}
		System.out.println(Character.isLetter('あ'));
		System.out.println(Character.isDigit('あ'));
		System.out.println(Character.isDigit('９'));
		System.out.println(Character.isLetterOrDigit('@'));
		System.out.println(Character.isLetterOrDigit('/'));
	}
}
