/*
 * This file is part of Nuts Framework.
 * Copyright(C) 2009-2012 Nuts Develop Team.
 *
 * Nuts Framework is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License any later version.
 * 
 * Nuts Framework is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Nuts Framework. If not, see <http://www.gnu.org/licenses/>.
 */
package nuts.core.lang;

import junit.framework.TestCase;

/**
 * test class for StringUtils
 */
public class StringUtilsTest extends TestCase {

	/**
	 * test method: wildMatch
	 * @throws Exception if an error occurs
	 */
	public void testWildMatch() throws Exception {
		assertTrue(StringUtils.wildcardMatch("", ""));
		assertTrue(StringUtils.wildcardMatch("ab", "ab"));
		assertTrue(StringUtils.wildcardMatch("ab", "ab*"));
		assertFalse(StringUtils.wildcardMatch("abc", "ab"));
		assertTrue(StringUtils.wildcardMatch("aab", "a?b"));
		assertFalse(StringUtils.wildcardMatch("abc", "a?b"));
		assertTrue(StringUtils.wildcardMatch("aaaccdsbbb", "a*b"));
		assertFalse(StringUtils.wildcardMatch("aaaccdsbbb", "a*z"));
	}

	/**
	 * test method: split
	 * @throws Exception if an error occurs
	 */
	public void testSplit() throws Exception {
		String[] cs = "abc".split("");
		
		assertEquals("", cs[0]);
		assertEquals("a", cs[1]);
		assertEquals("b", cs[2]);
		assertEquals("c", cs[3]);
	}

	/**
	 * test method: startsWith
	 * @throws Exception if an error occurs
	 */
	public void testStartsWithChars() throws Exception {
		assertTrue(StringUtils.startsWithChars("adga", "abc"));
	}
}
