/*
 * This file is part of Nuts Framework.
 * Copyright(C) 2009-2012 Nuts Develop Team.
 *
 * Nuts Framework is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License any later version.
 * 
 * Nuts Framework is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Nuts Framework. If not, see <http://www.gnu.org/licenses/>.
 */
package nuts.core.lang;

import junit.framework.TestCase;

/**
 */
public class StaticMethodTest extends TestCase {
	public static class T1 {
		public static void print0(String text) {
			print("000" + text);
		}
		
		public static void print(String text) {
			System.out.println(text);
		}
	}
	
	public static class T2 extends T1 {
		public static void print(String text) {
			System.out.println("111" + text);
		}
	}
	
	/**
	 * @throws Exception if an error occurs
	 */
	public void testStatic01() throws Exception {
		T1.print0("test");
	}
	
	/**
	 * @throws Exception if an error occurs
	 */
	public void testStatic02() throws Exception {
		T2.print0("test");
	}

}
