/*
 * This file is part of Nuts Framework.
 * Copyright(C) 2009-2012 Nuts Develop Team.
 *
 * Nuts Framework is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License any later version.
 * 
 * Nuts Framework is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Nuts Framework. If not, see <http://www.gnu.org/licenses/>.
 */
package nuts.core.lang;

import junit.framework.TestCase;

/**
 * test class for StringUtils
 */
public class JsonUtilsTest extends TestCase {

	public static class A {
		public int i = 1;
		public String s = "s";
		
		public A self;
		public A other;
		
		public A() {
			self = this;
		}

		/**
		 * @return the i
		 */
		public int getI() {
			return i;
		}

		/**
		 * @param i the i to set
		 */
		public void setI(int i) {
			this.i = i;
		}

		/**
		 * @return the s
		 */
		public String getS() {
			return s;
		}

		/**
		 * @param s the s to set
		 */
		public void setS(String s) {
			this.s = s;
		}

		/**
		 * @return the self
		 */
		public A getSelf() {
			return self;
		}

		/**
		 * @param self the self to set
		 */
		public void setSelf(A self) {
			this.self = self;
		}

		/**
		 * @return the other
		 */
		public A getOther() {
			return other;
		}

		/**
		 * @param other the other to set
		 */
		public void setOther(A other) {
			this.other = other;
		}
	}

	/**
	 */
	public void testCycle() throws Exception {
		A a = new A();
		a.other = new A();
		assertEquals("{[\"i\":1,\"other\":{\"i\":1,\"other\":null,\"s\":\"s\",\"self\":null},\"s\":\"s\",\"self\":null]}", JsonUtils.toJson(a));
	}
}
