/*
 * This file is part of Nuts Framework.
 * Copyright(C) 2009-2012 Nuts Develop Team.
 *
 * Nuts Framework is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License any later version.
 * 
 * Nuts Framework is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Nuts Framework. If not, see <http://www.gnu.org/licenses/>.
 */
package nuts.core.lang;

import junit.framework.TestCase;
import nuts.core.io.IOUtils;

/**
 * DynamicClassLoaderTest
 */
public class DynamicClassLoaderTest extends TestCase {
	static DynamicClassLoader loader = new DynamicClassLoader();

	/**
	 * test010
	 * @throws Exception if an error occurs
	 */
	public void test010() throws Exception {
		String source = IOUtils.toString(this.getClass().getResourceAsStream("DynamicTest0.java.txt"));
		
		String className = this.getClass().getPackage().getName() + ".DynamicTest0";
		loader.defineClass(className, source);
		
		Class c = loader.loadClass(className);
		assertNotNull(c);
		assertEquals(className, c.getName());

		String classNameI = className + "$PublicInner"; 
		Class ci = ClassUtils.getClass(loader, classNameI);
		assertNotNull(ci);
		assertEquals(classNameI, ci.getName());

		Object o = c.newInstance();
		assertEquals("-1", o.toString());
	}
	
	/**
	 * test020
	 * @throws Exception if an error occurs
	 */
	public void test020() throws Exception {
		String source = IOUtils.toString(this.getClass().getResourceAsStream("DynamicTest.java.txt"));
		
		String className = this.getClass().getPackage().getName() + ".DynamicTest";
		loader.defineClass(className, source);
		
		Class c = loader.loadClass(className);
		assertNotNull(c);
		assertEquals(className, c.getName());

		String classNameI = className + "$PublicInner"; 
		Class ci = ClassUtils.getClass(loader, classNameI);
		assertNotNull(ci);
		assertEquals(classNameI, ci.getName());

		Object o = c.newInstance();
		assertEquals("1", o.toString());
	}
	
	/**
	 * test030
	 * @throws Exception if an error occurs
	 */
	public void test030() throws Exception {
		String source = IOUtils.toString(this.getClass().getResourceAsStream("DynamicTest.java.2.txt"));
		
		String className = this.getClass().getPackage().getName() + ".DynamicTest";
		loader.defineClass(className, source);
		
		Class<?> c = loader.loadClass(className);
		assertNotNull(c);
		assertEquals(className, c.getName());

		String classNameI = className + "$PublicInner"; 
		Class ci = ClassUtils.getClass(loader, classNameI);
		assertNotNull(ci);
		assertEquals(classNameI, ci.getName());

		Object o = c.newInstance();
		assertEquals("2", o.toString());
	}

	/**
	 * test040
	 * @throws Exception if an error occurs
	 */
	public void test040() throws Exception {
		String className = this.getClass().getPackage().getName() + ".DynamicTest0";
		
		Class c = loader.loadClass(className);
		assertNotNull(c);
		assertEquals(className, c.getName());

		String classNameI = className + "$PublicInner"; 
		Class ci = ClassUtils.getClass(loader, classNameI);
		assertNotNull(ci);
		assertEquals(classNameI, ci.getName());

		Object o = c.newInstance();
		assertEquals("-1", o.toString());
	}

	/**
	 * test050
	 * @throws Exception if an error occurs
	 */
	public void test050() throws Exception {
		String className = this.getClass().getPackage().getName() + ".DynamicTest";
		
		Class c = loader.loadClass(className);
		assertNotNull(c);
		assertEquals(className, c.getName());

		String classNameI = className + "$PublicInner"; 
		Class ci = ClassUtils.getClass(loader, classNameI);
		assertNotNull(ci);
		assertEquals(classNameI, ci.getName());

		Object o = c.newInstance();
		assertEquals("2", o.toString());
	}
	
}
