/*
 * This file is part of Nuts Framework.
 * Copyright(C) 2009-2012 Nuts Develop Team.
 *
 * Nuts Framework is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License any later version.
 * 
 * Nuts Framework is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Nuts Framework. If not, see <http://www.gnu.org/licenses/>.
 */
package nuts.core.lang;

import nuts.core.i18n.AsiaCharUtils;
import junit.framework.TestCase;

/**
 * test class for AsiaCharUtils
 */
public class AsiaCharUtilsTest extends TestCase {

	/**
	 * test method: IsHankakuKatakanaChar
	 */
	public void testIsHankakuKatakanaChar() {
		assertFalse(AsiaCharUtils.isHankakuKatakanaChar('a'));
		assertTrue(AsiaCharUtils.isHankakuKatakanaChar('\uff88'));
	}

	/**
	 * test method: isZenkakuKatakanaChar
	 */
	public void testIsZenkakuKatakanaChar() {
		assertFalse(AsiaCharUtils.isZenkakuKatakanaChar('a'));
		assertTrue(AsiaCharUtils.isZenkakuKatakanaChar('\u30a1'));
	}

	/**
	 * test method: isHankakuChar
	 */
	public void testIsHankakuChar() {
		assertFalse(AsiaCharUtils.isHankakuChar('\250'));
		assertFalse(AsiaCharUtils.isHankakuChar('\u300b'));
		assertTrue(AsiaCharUtils.isHankakuChar('a'));
	}

	/**
	 * test method: isZenkakuChar
	 */
	public void testIsZenkakuChar() {
		assertFalse(AsiaCharUtils.isZenkakuChar('a'));
		assertTrue(AsiaCharUtils.isZenkakuChar('\u3011'));
	}

}
