/*
 * This file is part of Nuts Framework.
 * Copyright(C) 2009-2012 Nuts Develop Team.
 *
 * Nuts Framework is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License any later version.
 * 
 * Nuts Framework is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Nuts Framework. If not, see <http://www.gnu.org/licenses/>.
 */
package nuts.core.io;

import junit.framework.TestCase;

/**
 */
public class IOUtilsTest extends TestCase {

	/**
	 * test method: GetFileName
	 */
	public void testGetFileName() {
		assertEquals("1.js", IOUtils.getFileName("/a/1.js"));
	}

	/**
	 * test method: GetFileNameExtension
	 */
	public void testGetFileNameExtension() {
		assertEquals("js", IOUtils.getFileNameExtension("/a/1.js"));
		assertEquals("", IOUtils.getFileNameExtension("/a/2"));
	}

	/**
	 * test method: GetContentTypeForName
	 */
	public void testGetContentTypeForName() {
		assertEquals("image/gif", IOUtils.getContentTypeFor("/a/s1.gif"));
		System.out.println(IOUtils.getContentTypeFor("1.js"));
		System.out.println(IOUtils.getContentTypeFor("c.css"));
	}

	/**
	 * test method: isAbsolutePath
	 */
	public void testIsAbsolutePath() {
		assertTrue(IOUtils.isAbsolutePath("/a/s1.gif"));
		assertTrue(IOUtils.isAbsolutePath("C:/1.js"));
		assertTrue(IOUtils.isAbsolutePath("C:\\1.js"));
		assertFalse(IOUtils.isAbsolutePath("c.css"));
	}

}
