/*
 * This file is part of Nuts Framework.
 * Copyright(C) 2009-2012 Nuts Develop Team.
 *
 * Nuts Framework is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License any later version.
 * 
 * Nuts Framework is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Nuts Framework. If not, see <http://www.gnu.org/licenses/>.
 */
package nuts.core.collections;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import junit.framework.TestCase;

/**
 */
public class CollectionUtilsTest extends TestCase {

	/**
	 */
	public void testRemoveNullCol() {
		List<String> tl = new ArrayList<String>();
		
		tl.add(null);
		tl.add("t1");
		tl.add(null);
		tl.add("t2");
		
		System.out.println(tl);
		
		CollectionUtils.removeNull(tl);

		System.out.println(tl);
	}

	/**
	 */
	public void testRemoveNullMap() {
		Map<String, String> m = new HashMap<String, String>();
		
		m.put("1", null);
		m.put("2", "t1");
		m.put("3", null);
		m.put("4", "t2");
		
		System.out.println(m);
		
		CollectionUtils.removeNull(m);

		System.out.println(m);
	}

}
