package nuts.core.beans;

import junit.framework.TestCase;

import nuts.core.util.Profiler;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/**
 */
public class PerformanceTest extends TestCase {

	private static Log log = LogFactory.getLog(PerformanceTest.class);

	private static final int PCOUNT = 10;
	private static final int ECOUNT = 5000000;
	
	/**
	 */
	public void testDirect() {
		for (int i = 0; i < PCOUNT; i++) {
			TestA a = new TestA();
			a.isBoolField();
			a.setBoolField(true);
		}

		Profiler pf = new Profiler("testDirect");
		for (int i = 0; i < ECOUNT; i++) {
			TestA a = new TestA();
			a.isBoolField();
			a.setBoolField(true);
		}
		
		log.info(pf.elapsed());
	}

	/**
	 */
	@SuppressWarnings("unchecked")
	public void testJavaBeanHandler() {
		BeanHandlerFactory.setInstance(new BeanHandlerFactory());
		BeanHandler bh = BeanHandlerFactory.getInstance().createBeanHandler(TestA.class);
		
		for (int i = 0; i < PCOUNT; i++) {
			Object a = bh.createObject();
			bh.getBeanValue(a, "boolField");
			bh.setBeanValue(a, "boolField", false);
		}

		Profiler pf = new Profiler("testJavaBeanHandler");
		for (int i = 0; i < ECOUNT; i++) {
			Object a = bh.createObject();
			bh.getBeanValue(a, "boolField");
			bh.setBeanValue(a, "boolField", false);
		}
		
		log.info(pf.elapsed());
	}

	/**
	 */
	@SuppressWarnings("unchecked")
	public void testFastBeanHandler() {

		BeanHandlerFactory.setInstance(new FastBeanHandlerFactory());
		BeanHandler bh = BeanHandlerFactory.getInstance().createBeanHandler(TestA.class);
		
		for (int i = 0; i < PCOUNT; i++) {
			Object a = bh.createObject();
			bh.getBeanValue(a, "boolField");
			bh.setBeanValue(a, "boolField", false);
		}

		Profiler pf = new Profiler("testFastBeanHandler");
		for (int i = 0; i < ECOUNT; i++) {
			Object a = bh.createObject();
			bh.getBeanValue(a, "boolField");
			bh.setBeanValue(a, "boolField", false);
		}
		
		log.info(pf.elapsed());
	}
}
