/*
 * This file is part of Nuts Framework.
 * Copyright(C) 2009-2012 Nuts Develop Team.
 *
 * Nuts Framework is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License any later version.
 * 
 * Nuts Framework is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Nuts Framework. If not, see <http://www.gnu.org/licenses/>.
 */
package nuts.core.util.progressbar;

import java.io.PrintStream;


/**
 * A progress windmill of console
 */
public class ConsoleWindmillBar extends ConsoleProgressBar {

	private static final char[] WINDMILL = { '-', '\\', '|', '/' };
	
	private int frame = 0;
	
	/**
	 * constructor
	 */
	public ConsoleWindmillBar() {
		super();

		setSize(1);
	}

	/**
	 * constructor
	 * @param out output
	 */
	public ConsoleWindmillBar(PrintStream out) {
		super(out);
		
		setSize(1);
	}

	/**
	 * draw progress
	 */
	protected void draw() {
		clear();
		out.print(WINDMILL[frame]);
		out.flush();
		
		frame++;
		if (frame >= WINDMILL.length) {
			frame = 0;
		}
	}

}
